/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.dom;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomCharacterData;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Node;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;

@JsxClass
public class CharacterData
extends Node {
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public CharacterData() {
    }

    @JsxGetter
    public Object getData() {
        return this.getDomCharacterDataOrDie().getData();
    }

    @JsxSetter
    public void setData(String newValue) {
        this.getDomCharacterDataOrDie().setData(newValue);
    }

    @JsxGetter
    public int getLength() {
        return this.getDomCharacterDataOrDie().getLength();
    }

    @JsxFunction
    public void appendData(String arg) {
        this.getDomCharacterDataOrDie().appendData(arg);
    }

    @JsxFunction
    public void deleteData(int offset, int count) {
        DomCharacterData domCharacterData;
        if (offset < 0) {
            throw Context.reportRuntimeError((String)("Provided offset: " + offset + " is less than zero."));
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOM_CDATA_DELETE_THROWS_NEGATIVE_COUNT)) {
            if (count < 0) {
                throw Context.reportRuntimeError((String)("Provided count: " + count + " is less than zero."));
            }
            if (count == 0) {
                return;
            }
        }
        if (offset > (domCharacterData = this.getDomCharacterDataOrDie()).getLength()) {
            throw Context.reportRuntimeError((String)("Provided offset: " + offset + " is greater than length."));
        }
        domCharacterData.deleteData(offset, count);
    }

    @JsxFunction
    public void insertData(int offset, String arg) {
        this.getDomCharacterDataOrDie().insertData(offset, arg);
    }

    @JsxFunction
    public void replaceData(int offset, int count, String arg) {
        this.getDomCharacterDataOrDie().replaceData(offset, count, arg);
    }

    @JsxFunction
    public String substringData(int offset, int count) {
        return this.getDomCharacterDataOrDie().substringData(offset, count);
    }

    private DomCharacterData getDomCharacterDataOrDie() {
        return (DomCharacterData)super.getDomNodeOrDie();
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Element getNextElementSibling() {
        DomElement child = this.getDomNodeOrDie().getNextElementSibling();
        if (child != null) {
            return (Element)child.getScriptableObject();
        }
        return null;
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Element getPreviousElementSibling() {
        DomElement child = this.getDomNodeOrDie().getPreviousElementSibling();
        if (child != null) {
            return (Element)child.getScriptableObject();
        }
        return null;
    }

    @Override
    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void remove() {
        super.remove();
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public static void before(Context context, Scriptable thisObj, Object[] args, Function function) {
        Node.before(context, thisObj, args, function);
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public static void after(Context context, Scriptable thisObj, Object[] args, Function function) {
        Node.after(context, thisObj, args, function);
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public static void replaceWith(Context context, Scriptable thisObj, Object[] args, Function function) {
        Node.replaceWith(context, thisObj, args, function);
    }
}

