/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.sitemaps;

import crawlercommons.sitemaps.SiteMap;
import java.io.Serializable;
import java.net.URL;
import java.time.LocalDate;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Locale;

public abstract class AbstractSiteMap
implements Serializable {
    protected static final ZoneId TIME_ZONE_UTC = ZoneId.of(ZoneOffset.UTC.toString());
    public static final DateTimeFormatter W3C_FULLDATE_FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
    public static final DateTimeFormatter W3C_FULLDATE_FORMATTER_UTC = DateTimeFormatter.ISO_INSTANT;
    public static final DateTimeFormatter W3C_SHORTDATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy[-MM[-dd]]", Locale.ROOT).withZone(TIME_ZONE_UTC);
    private Date lastModified = null;
    private SitemapType type;
    private boolean processed;
    protected URL url;

    public boolean isIndex() {
        return this.type == SitemapType.INDEX;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setType(SitemapType type) {
        this.type = type;
    }

    public SitemapType getType() {
        return this.type;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public void setLastModified(ZonedDateTime lastModified) {
        this.lastModified = Date.from(lastModified.toInstant());
    }

    public void setLastModified(String lastModified) {
        this.lastModified = SiteMap.convertToDate(lastModified);
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public static ZonedDateTime convertToZonedDateTime(String date) {
        if (date == null) {
            return null;
        }
        try {
            return W3C_FULLDATE_FORMATTER.parse((CharSequence)date, ZonedDateTime::from);
        }
        catch (DateTimeParseException dateTimeParseException) {
            try {
                TemporalAccessor ta = W3C_SHORTDATE_FORMATTER.parse(date);
                LocalDate ldt = null;
                if (ta.isSupported(ChronoField.DAY_OF_MONTH)) {
                    ldt = LocalDate.from(ta);
                } else if (ta.isSupported(ChronoField.MONTH_OF_YEAR)) {
                    ldt = YearMonth.from(ta).atDay(1);
                } else if (ta.isSupported(ChronoField.YEAR)) {
                    ldt = Year.from(ta).atDay(1);
                }
                if (ldt != null) {
                    return ldt.atStartOfDay(TIME_ZONE_UTC);
                }
            }
            catch (DateTimeParseException dateTimeParseException2) {
                // empty catch block
            }
            return null;
        }
    }

    public static Date convertToDate(String date) {
        ZonedDateTime zdt = AbstractSiteMap.convertToZonedDateTime(date);
        if (zdt == null) {
            return null;
        }
        return Date.from(zdt.toInstant());
    }

    public static String normalizeRSSTimestamp(String pubDate) {
        if (pubDate == null) {
            return null;
        }
        ZonedDateTime zdt = AbstractSiteMap.parseRSSTimestamp(pubDate);
        if (zdt == null) {
            return pubDate;
        }
        return W3C_FULLDATE_FORMATTER_UTC.format(zdt);
    }

    public static ZonedDateTime parseRSSTimestamp(String pubDate) {
        ZonedDateTime zdt = null;
        try {
            zdt = DateTimeFormatter.RFC_1123_DATE_TIME.parse((CharSequence)pubDate, ZonedDateTime::from);
        }
        catch (DateTimeParseException ex) {
            return null;
        }
        if (zdt.getYear() <= 99 && zdt.getYear() >= 0) {
            zdt = zdt.getYear() >= 80 ? zdt.plusYears(1900L) : zdt.plusYears(2000L);
        }
        return zdt;
    }

    public static enum SitemapType {
        INDEX,
        XML,
        ATOM,
        RSS,
        TEXT;

    }
}

