/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.tools;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.metadata.Metadata;
import org.apache.nutch.protocol.Content;
import org.apache.nutch.tools.AbstractCommonCrawlFormat;
import org.apache.nutch.tools.CommonCrawlConfig;

public class CommonCrawlFormatJackson
extends AbstractCommonCrawlFormat {
    private ByteArrayOutputStream out;
    private JsonGenerator generator;

    public CommonCrawlFormatJackson(Configuration nutchConf, CommonCrawlConfig config) throws IOException {
        super(null, null, null, nutchConf, config);
        JsonFactory factory = new JsonFactory();
        this.out = new ByteArrayOutputStream();
        this.generator = factory.createGenerator((OutputStream)this.out);
        this.generator.useDefaultPrettyPrinter();
    }

    public CommonCrawlFormatJackson(String url, Content content, Metadata metadata, Configuration nutchConf, CommonCrawlConfig config) throws IOException {
        super(url, content, metadata, nutchConf, config);
        JsonFactory factory = new JsonFactory();
        this.out = new ByteArrayOutputStream();
        this.generator = factory.createGenerator((OutputStream)this.out);
        this.generator.useDefaultPrettyPrinter();
    }

    @Override
    protected void writeKeyValue(String key, String value) throws IOException {
        this.generator.writeFieldName(key);
        this.generator.writeString(value);
    }

    @Override
    protected void writeKeyNull(String key) throws IOException {
        this.generator.writeFieldName(key);
        this.generator.writeNull();
    }

    @Override
    protected void startArray(String key, boolean nested, boolean newline) throws IOException {
        if (key != null) {
            this.generator.writeFieldName(key);
        }
        this.generator.writeStartArray();
    }

    @Override
    protected void closeArray(String key, boolean nested, boolean newline) throws IOException {
        this.generator.writeEndArray();
    }

    @Override
    protected void writeArrayValue(String value) throws IOException {
        this.generator.writeString(value);
    }

    @Override
    protected void startObject(String key) throws IOException {
        if (key != null) {
            this.generator.writeFieldName(key);
        }
        this.generator.writeStartObject();
    }

    @Override
    protected void closeObject(String key) throws IOException {
        this.generator.writeEndObject();
    }

    @Override
    protected String generateJson() throws IOException {
        this.generator.flush();
        return this.out.toString();
    }
}

