/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.parse;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.crawl.SignatureFactory;
import org.apache.nutch.net.URLNormalizers;
import org.apache.nutch.parse.Parse;
import org.apache.nutch.parse.ParseResult;
import org.apache.nutch.parse.ParseSegment;
import org.apache.nutch.parse.ParseUtil;
import org.apache.nutch.plugin.PluginRepository;
import org.apache.nutch.protocol.Content;
import org.apache.nutch.protocol.ProtocolOutput;
import org.apache.nutch.scoring.ScoringFilters;
import org.apache.nutch.util.AbstractChecker;
import org.apache.nutch.util.NutchConfiguration;
import org.apache.nutch.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserChecker
extends AbstractChecker {
    protected URLNormalizers normalizers = null;
    protected boolean dumpText = false;
    protected boolean followRedirects = false;
    protected boolean checkRobotsTxt = false;
    protected HashMap<String, String> metadata = new HashMap();
    protected String forceAsContentType = null;
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ScoringFilters scfilters;

    public int run(String[] args) throws Exception {
        String url = null;
        String usage = "Usage:\n  ParserChecker [OPTIONS] <url>\n    Fetch single URL and parse it\n  ParserChecker [OPTIONS] -stdin\n    Read URLs to be parsed from stdin\n  ParserChecker [OPTIONS] -listen <port> [-keepClientCnxOpen]\n    Listen on <port> for URLs to be parsed\nOptions:\n  -D<property>=<value>\tset/overwrite Nutch/Hadoop properties\n                  \t(a generic Hadoop option to be passed\n                  \t before other command-specific options)\n  -normalize      \tnormalize URLs\n  -followRedirects\tfollow redirects when fetching URL\n  -checkRobotsTxt\tfail if the robots.txt disallows fetching\n  -dumpText       \talso show the plain-text extracted by parsers\n  -forceAs <mimeType>\tforce parsing as <mimeType>\n  -md <key>=<value>\tmetadata added to CrawlDatum before parsing\n";
        if (args.length < 1) {
            System.err.println(usage);
            return -1;
        }
        PluginRepository.get(this.getConf());
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-normalize")) {
                this.normalizers = new URLNormalizers(this.getConf(), "default");
                continue;
            }
            if (args[i].equals("-followRedirects")) {
                this.followRedirects = true;
                continue;
            }
            if (args[i].equals("-checkRobotsTxt")) {
                this.checkRobotsTxt = true;
                continue;
            }
            if (args[i].equals("-forceAs")) {
                this.forceAsContentType = args[++i];
                continue;
            }
            if (args[i].equals("-dumpText")) {
                this.dumpText = true;
                continue;
            }
            if (args[i].equals("-md")) {
                String nextOne;
                int firstEquals;
                String k = null;
                String v = null;
                if ((firstEquals = (nextOne = args[++i]).indexOf("=")) != -1) {
                    k = nextOne.substring(0, firstEquals);
                    v = nextOne.substring(firstEquals + 1);
                } else {
                    k = nextOne;
                }
                this.metadata.put(k, v);
                continue;
            }
            int numConsumed = super.parseArgs(args, i);
            if (numConsumed > 0) {
                i += numConsumed - 1;
                continue;
            }
            if (i != args.length - 1) {
                System.err.println("ERR: Not a recognized argument: " + args[i]);
                System.err.println(usage);
                return -1;
            }
            url = args[i];
        }
        this.scfilters = new ScoringFilters(this.getConf());
        if (url != null) {
            return super.processSingle(url);
        }
        return super.run();
    }

    @Override
    protected int process(String url, StringBuilder output) throws Exception {
        String contentType;
        int numRedirects;
        if (this.normalizers != null) {
            url = this.normalizers.normalize(url, "default");
        }
        LOG.info("fetching: {}", (Object)url);
        CrawlDatum datum = new CrawlDatum();
        for (String key : this.metadata.keySet()) {
            String value = this.metadata.get(key);
            if (value == null) {
                value = "";
            }
            datum.getMetaData().put((Writable)new Text(key), (Writable)new Text(value));
        }
        int maxRedirects = this.getConf().getInt("http.redirect.max", 3);
        if (this.followRedirects) {
            if (maxRedirects == 0) {
                LOG.info("Following max. 3 redirects (ignored http.redirect.max == 0)");
                maxRedirects = 3;
            } else {
                LOG.info("Following max. {} redirects", (Object)maxRedirects);
            }
        }
        ProtocolOutput protocolOutput = this.getProtocolOutput(url, datum, this.checkRobotsTxt);
        Text turl = new Text(url);
        for (numRedirects = 0; protocolOutput != null && !protocolOutput.getStatus().isSuccess() && this.followRedirects && protocolOutput.getStatus().isRedirect() && maxRedirects >= numRedirects; ++numRedirects) {
            String[] stuff = protocolOutput.getStatus().getArgs();
            url = stuff[0];
            LOG.info("Follow redirect to {}", (Object)url);
            if (this.normalizers != null) {
                url = this.normalizers.normalize(url, "default");
            }
            turl.set(url);
            protocolOutput = this.getProtocolOutput(url, datum, this.checkRobotsTxt);
        }
        if (this.checkRobotsTxt && protocolOutput == null) {
            System.err.println("Fetch disallowed by robots.txt");
            return -1;
        }
        if (!protocolOutput.getStatus().isSuccess()) {
            System.err.println("Fetch failed with protocol status: " + String.valueOf(protocolOutput.getStatus()));
            if (protocolOutput.getStatus().isRedirect()) {
                System.err.println("Redirect(s) not handled due to configuration.");
                System.err.println("Max Redirects to handle per config: " + maxRedirects);
                System.err.println("Number of Redirects handled: " + numRedirects);
            }
            return -1;
        }
        Content content = protocolOutput.getContent();
        if (content == null) {
            output.append("No content for " + url + "\n");
            return 0;
        }
        if (this.forceAsContentType != null) {
            content.setContentType(this.forceAsContentType);
            contentType = this.forceAsContentType;
        } else {
            contentType = content.getContentType();
        }
        if (contentType == null) {
            LOG.error("Failed to determine content type!");
            return -1;
        }
        datum.getMetaData().put((Writable)new Text("Content-Type"), (Writable)new Text(contentType));
        if (ParseSegment.isTruncated(content)) {
            LOG.warn("Content is truncated, parse may fail!");
        }
        try {
            this.scfilters.passScoreBeforeParsing(turl, datum, content);
        }
        catch (Exception e) {
            LOG.warn("Couldn't pass score before parsing, url {} ({})", (Object)turl, (Object)e);
            LOG.warn(StringUtils.stringifyException((Throwable)e));
        }
        ParseResult parseResult = new ParseUtil(this.getConf()).parse(content);
        if (parseResult == null) {
            LOG.error("Parsing content failed!");
            return -1;
        }
        byte[] signature = SignatureFactory.getSignature(this.getConf()).calculate(content, parseResult.get(new Text(url)));
        LOG.info("parsing: {}", (Object)url);
        LOG.info("contentType: {}", (Object)contentType);
        LOG.info("signature: {}", (Object)StringUtil.toHexString(signature));
        for (Map.Entry<Text, Parse> entry : parseResult) {
            turl = entry.getKey();
            Parse parse = entry.getValue();
            try {
                this.scfilters.passScoreAfterParsing(turl, content, parse);
            }
            catch (Exception e) {
                LOG.warn("Couldn't pass score after parsing, url {} ({})", (Object)turl, (Object)e);
                LOG.warn(StringUtils.stringifyException((Throwable)e));
            }
            output.append(turl).append("\n");
            output.append((Object)parse.getData()).append("\n");
            if (!this.dumpText) continue;
            output.append(parse.getText());
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)NutchConfiguration.create(), (Tool)new ParserChecker(), (String[])args);
        System.exit(res);
    }
}

