/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.hostdb;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class HostDatum
implements Writable,
Cloneable {
    protected long failures = 0L;
    protected float score = 0.0f;
    protected Date lastCheck = new Date(0L);
    protected String homepageUrl = new String();
    protected MapWritable metaData = null;
    protected static final byte[] emptyMetaDataWritableSerialized;
    protected long dnsFailures = 0L;
    protected long connectionFailures = 0L;
    protected long unfetched = 0L;
    protected long fetched = 0L;
    protected long notModified = 0L;
    protected long redirTemp = 0L;
    protected long redirPerm = 0L;
    protected long gone = 0L;

    public HostDatum() {
    }

    public HostDatum(float score) {
        this(score, new Date());
    }

    public HostDatum(float score, Date lastCheck) {
        this(score, lastCheck, new String());
    }

    public HostDatum(float score, Date lastCheck, String homepageUrl) {
        this.score = score;
        this.lastCheck = lastCheck;
        this.homepageUrl = homepageUrl;
    }

    public void resetFailures() {
        this.setDnsFailures(0L);
        this.setConnectionFailures(0L);
    }

    public void setDnsFailures(Long dnsFailures) {
        this.dnsFailures = dnsFailures;
    }

    public void setConnectionFailures(Long connectionFailures) {
        this.connectionFailures = connectionFailures;
    }

    public void incDnsFailures() {
        ++this.dnsFailures;
    }

    public void incConnectionFailures() {
        ++this.connectionFailures;
    }

    public Long numFailures() {
        return this.getDnsFailures() + this.getConnectionFailures();
    }

    public Long getDnsFailures() {
        return this.dnsFailures;
    }

    public Long getConnectionFailures() {
        return this.connectionFailures;
    }

    public void setScore(float score) {
        this.score = score;
    }

    public void setLastCheck() {
        this.setLastCheck(new Date());
    }

    public void setLastCheck(Date date) {
        this.lastCheck = date;
    }

    public boolean isEmpty() {
        return this.lastCheck.getTime() == 0L;
    }

    public float getScore() {
        return this.score;
    }

    public Long numRecords() {
        return this.unfetched + this.fetched + this.gone + this.redirPerm + this.redirTemp + this.notModified;
    }

    public Date getLastCheck() {
        return this.lastCheck;
    }

    public boolean hasHomepageUrl() {
        return this.homepageUrl.isEmpty();
    }

    public String getHomepageUrl() {
        return this.homepageUrl;
    }

    public void setHomepageUrl(String homepageUrl) {
        this.homepageUrl = homepageUrl;
    }

    public void setUnfetched(long val) {
        this.unfetched = val;
    }

    public long getUnfetched() {
        return this.unfetched;
    }

    public void setFetched(long val) {
        this.fetched = val;
    }

    public long getFetched() {
        return this.fetched;
    }

    public void setNotModified(long val) {
        this.notModified = val;
    }

    public long getNotModified() {
        return this.notModified;
    }

    public void setRedirTemp(long val) {
        this.redirTemp = val;
    }

    public long getRedirTemp() {
        return this.redirTemp;
    }

    public void setRedirPerm(long val) {
        this.redirPerm = val;
    }

    public long getRedirPerm() {
        return this.redirPerm;
    }

    public void setGone(long val) {
        this.gone = val;
    }

    public long getGone() {
        return this.gone;
    }

    public void resetStatistics() {
        this.setUnfetched(0L);
        this.setFetched(0L);
        this.setGone(0L);
        this.setRedirTemp(0L);
        this.setRedirPerm(0L);
        this.setNotModified(0L);
    }

    public void setMetaData(MapWritable mapWritable) {
        this.metaData = new MapWritable(mapWritable);
    }

    public void putAllMetaData(HostDatum other) {
        if (other.hasMetaData()) {
            for (Map.Entry e : other.getMetaData().entrySet()) {
                this.getMetaData().put((Writable)e.getKey(), (Writable)e.getValue());
            }
        }
    }

    public MapWritable getMetaData() {
        if (this.metaData == null) {
            this.metaData = new MapWritable();
        }
        return this.metaData;
    }

    public boolean hasMetaData() {
        return this.metaData != null && !this.metaData.isEmpty();
    }

    public Object clone() throws CloneNotSupportedException {
        HostDatum result = (HostDatum)super.clone();
        result.score = this.score;
        result.lastCheck = this.lastCheck;
        result.homepageUrl = this.homepageUrl;
        result.dnsFailures = this.dnsFailures;
        result.connectionFailures = this.connectionFailures;
        result.unfetched = this.unfetched;
        result.fetched = this.fetched;
        result.notModified = this.notModified;
        result.redirTemp = this.redirTemp;
        result.redirPerm = this.redirPerm;
        result.gone = this.gone;
        result.metaData = this.metaData;
        return result;
    }

    public void readFields(DataInput in) throws IOException {
        this.score = in.readFloat();
        this.lastCheck = new Date(in.readLong());
        this.homepageUrl = Text.readString((DataInput)in);
        this.dnsFailures = in.readLong();
        this.connectionFailures = in.readLong();
        this.unfetched = in.readLong();
        this.fetched = in.readLong();
        this.notModified = in.readLong();
        this.redirTemp = in.readLong();
        this.redirPerm = in.readLong();
        this.gone = in.readLong();
        if (this.metaData == null) {
            this.metaData = new MapWritable();
        } else {
            this.metaData.clear();
        }
        this.metaData.readFields(in);
    }

    public void write(DataOutput out) throws IOException {
        out.writeFloat(this.score);
        out.writeLong(this.lastCheck.getTime());
        Text.writeString((DataOutput)out, (String)this.homepageUrl);
        out.writeLong(this.dnsFailures);
        out.writeLong(this.connectionFailures);
        out.writeLong(this.unfetched);
        out.writeLong(this.fetched);
        out.writeLong(this.notModified);
        out.writeLong(this.redirTemp);
        out.writeLong(this.redirPerm);
        out.writeLong(this.gone);
        if (this.hasMetaData()) {
            this.metaData.write(out);
        } else {
            out.write(emptyMetaDataWritableSerialized);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(Long.toString(this.getUnfetched()));
        buf.append("\t");
        buf.append(Long.toString(this.getFetched()));
        buf.append("\t");
        buf.append(Long.toString(this.getGone()));
        buf.append("\t");
        buf.append(Long.toString(this.getRedirTemp()));
        buf.append("\t");
        buf.append(Long.toString(this.getRedirPerm()));
        buf.append("\t");
        buf.append(Long.toString(this.getNotModified()));
        buf.append("\t");
        buf.append(Long.toString(this.numRecords()));
        buf.append("\t");
        buf.append(Long.toString(this.getDnsFailures()));
        buf.append("\t");
        buf.append(Long.toString(this.getConnectionFailures()));
        buf.append("\t");
        buf.append(Long.toString(this.numFailures()));
        buf.append("\t");
        buf.append(Float.toString(this.score));
        buf.append("\t");
        buf.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(this.lastCheck));
        buf.append("\t");
        buf.append(this.homepageUrl);
        buf.append("\t");
        if (this.hasMetaData()) {
            for (Map.Entry e : this.getMetaData().entrySet()) {
                buf.append(((Writable)e.getKey()).toString());
                buf.append(':');
                buf.append(((Writable)e.getValue()).toString());
                buf.append("|||");
            }
        }
        return buf.toString();
    }

    static {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream outStream = new DataOutputStream(buffer);
        MapWritable emptyMetaData = new MapWritable();
        try {
            emptyMetaData.write((DataOutput)outStream);
            outStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        emptyMetaDataWritableSerialized = buffer.toByteArray();
    }
}

