/*
 * Decompiled with CFR 0.152.
 */
package io.ous.jtoml.impl;

import io.ous.jtoml.TomlTable;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectDeserializer {
    private static final Set<Class<?>> PRIMITIVES;
    private static final ObjectDeserializer INSTANCE;

    public static ObjectDeserializer getInstance() {
        return INSTANCE;
    }

    public <T> T create(Class<T> type, TomlTable group) {
        T ret = this.instantiate(type);
        this.visitFields(ret, group);
        return ret;
    }

    <T> T createField(Class<T> type, TomlTable containingTable, String keyName) {
        if (PRIMITIVES.contains(type)) {
            return type.cast(containingTable.get(keyName));
        }
        if (type.isEnum()) {
            return (T)containingTable.getAsEnum(type.asSubclass(Enum.class), keyName, new Object[0]);
        }
        TomlTable target = containingTable.getTomlTable(keyName, new Object[0]);
        return target == null ? null : (T)this.create(type, target);
    }

    void visitFields(Object obj, TomlTable groupForObject) {
        Class<?> clz = obj.getClass();
        while (!Object.class.equals(clz)) {
            this.visitClassFields(obj, groupForObject, clz);
            clz = clz.getSuperclass();
        }
    }

    void visitClassFields(Object obj, TomlTable groupForObject, Class<?> clz) {
        for (Field field : clz.getDeclaredFields()) {
            Object value = this.createField(field.getType(), groupForObject, field.getName());
            if (value == null) continue;
            field.setAccessible(true);
            try {
                field.set(obj, value);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not assign value to field " + field + " at " + clz, e);
            }
        }
    }

    <T> T instantiate(Class<T> type) {
        try {
            return type.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not instantiate " + type, e);
        }
    }

    public <T extends Enum<T>> T toEnum(Class<T> type, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            int ordinal = ((Long)value).intValue();
            return (T)((Enum[])type.getEnumConstants())[ordinal];
        }
        if (value instanceof String) {
            return Enum.valueOf(type, (String)value);
        }
        throw new IllegalArgumentException("Value is neither String or Long but " + value.getClass().getCanonicalName());
    }

    static {
        HashSet<Class> primitives = new HashSet<Class>();
        for (Class type : new Class[]{String.class, Date.class, List.class, Boolean.class, Double.class, Long.class}) {
            primitives.add(type);
        }
        PRIMITIVES = Collections.unmodifiableSet(primitives);
        INSTANCE = new ObjectDeserializer();
    }
}

