/*
 * Decompiled with CFR 0.152.
 */
package org.archive.url;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RewriteRule {
    protected String startsWith;
    protected String regex;
    protected String replace;
    protected Pattern regexPattern;

    public String getStartsWith() {
        return this.startsWith;
    }

    public void setStartsWith(String startsWith) {
        this.startsWith = startsWith;
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regexPattern = Pattern.compile(regex);
        this.regex = regex;
    }

    public String getReplace() {
        return this.replace;
    }

    public void setReplace(String replace) {
        this.replace = replace;
    }

    public boolean rewrite(StringBuilder sb) {
        String urlkey = sb.toString();
        if (this.startsWith != null && !urlkey.startsWith(this.startsWith)) {
            return false;
        }
        if (this.regexPattern == null || this.replace == null) {
            return false;
        }
        Matcher match = this.regexPattern.matcher(urlkey);
        if (match.matches()) {
            sb.replace(0, sb.length(), match.replaceAll(this.replace));
            return true;
        }
        return false;
    }
}

