/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.gzip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.archive.format.gzip.GZIPMemberWriter;
import org.archive.util.io.CommitedOutputStream;

public class GZIPMemberWriterCommittedOutputStream
extends CommitedOutputStream {
    private static int DEFAULT_BUFFER_RAM = 0x100000;
    private GZIPMemberWriter gzW;

    public GZIPMemberWriterCommittedOutputStream(GZIPMemberWriter gzW) {
        this(gzW, DEFAULT_BUFFER_RAM);
    }

    public GZIPMemberWriterCommittedOutputStream(GZIPMemberWriter gzW, int bufferRAM) {
        super(new ByteArrayOutputStream());
        this.gzW = gzW;
    }

    @Override
    public void commit() throws IOException {
        ByteArrayOutputStream bos = (ByteArrayOutputStream)this.out;
        this.gzW.write(new ByteArrayInputStream(bos.toByteArray()));
    }

    public long getBytesWritten() {
        return this.gzW.getBytesWritten();
    }
}

