/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.extension.bundle;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.nifi.registry.bucket.BucketItem;
import org.apache.nifi.registry.bucket.BucketItemType;
import org.apache.nifi.registry.extension.bundle.BundleType;

@ApiModel(value="ExtensionBundle")
@XmlRootElement
public class Bundle
extends BucketItem {
    @NotNull
    private BundleType bundleType;
    @NotBlank
    private String groupId;
    @NotBlank
    private String artifactId;
    @Min(value=0L)
    private @Min(value=0L) long versionCount;

    public Bundle() {
        super(BucketItemType.Bundle);
    }

    @ApiModelProperty(value="The type of the extension bundle")
    public BundleType getBundleType() {
        return this.bundleType;
    }

    public void setBundleType(BundleType bundleType) {
        this.bundleType = bundleType;
    }

    @ApiModelProperty(value="The group id of the extension bundle")
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @ApiModelProperty(value="The artifact id of the extension bundle")
    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    @ApiModelProperty(value="The number of versions of this extension bundle.", readOnly=true)
    public long getVersionCount() {
        return this.versionCount;
    }

    public void setVersionCount(long versionCount) {
        this.versionCount = versionCount;
    }
}

