/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.configuration.ingestors;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.minifi.bootstrap.ConfigurationFileHolder;
import org.apache.nifi.minifi.bootstrap.configuration.ConfigurationChangeNotifier;
import org.apache.nifi.minifi.bootstrap.configuration.differentiators.Differentiator;
import org.apache.nifi.minifi.bootstrap.configuration.differentiators.WholeConfigDifferentiator;
import org.apache.nifi.minifi.bootstrap.configuration.ingestors.interfaces.ChangeIngestor;
import org.apache.nifi.minifi.bootstrap.util.ConfigTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChangeIngestor
implements Runnable,
ChangeIngestor {
    private static final Map<String, Supplier<Differentiator<ByteBuffer>>> DIFFERENTIATOR_CONSTRUCTOR_MAP;
    protected static final int DEFAULT_POLLING_PERIOD_INTERVAL = 15;
    protected static final TimeUnit DEFAULT_POLLING_PERIOD_UNIT;
    private static final Logger logger;
    private static final String CONFIG_FILE_BASE_KEY = "nifi.minifi.notifier.ingestors.file";
    protected static final String CONFIG_FILE_PATH_KEY = "nifi.minifi.notifier.ingestors.file.config.path";
    protected static final String POLLING_PERIOD_INTERVAL_KEY = "nifi.minifi.notifier.ingestors.file.polling.period.seconds";
    public static final String DIFFERENTIATOR_KEY = "nifi.minifi.notifier.ingestors.file.differentiator";
    private Path configFilePath;
    private WatchService watchService;
    private long pollingSeconds;
    private volatile Differentiator<ByteBuffer> differentiator;
    private volatile ConfigurationChangeNotifier configurationChangeNotifier;
    private volatile ConfigurationFileHolder configurationFileHolder;
    private volatile Properties properties;
    private ScheduledExecutorService executorService;

    protected static WatchService initializeWatcher(Path filePath) {
        try {
            WatchService fsWatcher = FileSystems.getDefault().newWatchService();
            Path watchDirectory = filePath.getParent();
            watchDirectory.register(fsWatcher, StandardWatchEventKinds.ENTRY_MODIFY);
            return fsWatcher;
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Unable to initialize a file system watcher for the path " + filePath, ioe);
        }
    }

    protected boolean targetChanged() {
        Optional<WatchKey> watchKey = Optional.ofNullable(this.watchService.poll());
        boolean targetChanged = watchKey.map(WatchKey::pollEvents).orElse(Collections.emptyList()).stream().anyMatch(watchEvent -> StandardWatchEventKinds.ENTRY_MODIFY == watchEvent.kind() && ((Path)watchEvent.context()).equals(this.configFilePath.getName(this.configFilePath.getNameCount() - 1)));
        watchKey.map(WatchKey::reset).filter(valid -> valid == false).ifPresent(valid -> {
            throw new IllegalStateException("Unable to reinitialize file system watcher.");
        });
        return targetChanged;
    }

    @Override
    public void run() {
        logger.debug("Checking for a change");
        if (this.targetChanged()) {
            logger.debug("Target changed, checking if it's different than current flow.");
            try (FileInputStream configFile = new FileInputStream(this.configFilePath.toFile());){
                ByteBuffer readOnlyNewConfig = ConfigTransformer.overrideNonFlowSectionsFromOriginalSchema(IOUtils.toByteArray((InputStream)configFile), this.configurationFileHolder.getConfigFileReference().get().duplicate(), this.properties);
                if (this.differentiator.isNew(readOnlyNewConfig)) {
                    logger.debug("New change, notifying listener");
                    this.configurationChangeNotifier.notifyListeners(readOnlyNewConfig);
                    logger.debug("Listeners notified");
                }
            }
            catch (Exception e) {
                logger.error("Could not successfully notify listeners.", (Throwable)e);
            }
        }
    }

    @Override
    public void initialize(Properties properties, ConfigurationFileHolder configurationFileHolder, ConfigurationChangeNotifier configurationChangeNotifier) {
        this.properties = properties;
        this.configurationFileHolder = configurationFileHolder;
        String rawPath = properties.getProperty(CONFIG_FILE_PATH_KEY);
        String rawPollingDuration = properties.getProperty(POLLING_PERIOD_INTERVAL_KEY, Long.toString(15L));
        if (rawPath == null || rawPath.isEmpty()) {
            throw new IllegalArgumentException("Property, nifi.minifi.notifier.ingestors.file.config.path, for the path of the config file must be specified.");
        }
        try {
            this.setConfigFilePath(Paths.get(rawPath, new String[0]));
            this.setPollingPeriod(Long.parseLong(rawPollingDuration), DEFAULT_POLLING_PERIOD_UNIT);
            this.setWatchService(FileChangeIngestor.initializeWatcher(this.configFilePath));
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not successfully initialize file change notifier.", e);
        }
        this.configurationChangeNotifier = configurationChangeNotifier;
        String differentiatorName = properties.getProperty(DIFFERENTIATOR_KEY);
        if (differentiatorName != null && !differentiatorName.isEmpty()) {
            Supplier<Differentiator<ByteBuffer>> differentiatorSupplier = DIFFERENTIATOR_CONSTRUCTOR_MAP.get(differentiatorName);
            if (differentiatorSupplier == null) {
                throw new IllegalArgumentException("Property, nifi.minifi.notifier.ingestors.file.differentiator, has value " + differentiatorName + " which does not correspond to any in the PullHttpChangeIngestor Map:" + DIFFERENTIATOR_CONSTRUCTOR_MAP.keySet());
            }
            this.differentiator = differentiatorSupplier.get();
        } else {
            this.differentiator = WholeConfigDifferentiator.getByteBufferDifferentiator();
        }
        this.differentiator.initialize(configurationFileHolder);
    }

    protected void setConfigFilePath(Path configFilePath) {
        this.configFilePath = configFilePath;
    }

    protected void setWatchService(WatchService watchService) {
        this.watchService = watchService;
    }

    protected void setConfigurationChangeNotifier(ConfigurationChangeNotifier configurationChangeNotifier) {
        this.configurationChangeNotifier = configurationChangeNotifier;
    }

    protected void setDifferentiator(Differentiator<ByteBuffer> differentiator) {
        this.differentiator = differentiator;
    }

    protected void setPollingPeriod(long duration, TimeUnit unit) {
        if (duration < 0L) {
            throw new IllegalArgumentException("Cannot specify a polling period with duration <=0");
        }
        this.pollingSeconds = TimeUnit.SECONDS.convert(duration, unit);
    }

    @Override
    public void start() {
        this.executorService = Executors.newScheduledThreadPool(1, r -> {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setName("File Change Notifier Thread");
            t.setDaemon(true);
            return t;
        });
        this.executorService.scheduleWithFixedDelay(this, 0L, this.pollingSeconds, DEFAULT_POLLING_PERIOD_UNIT);
    }

    @Override
    public void close() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    static {
        HashMap<String, Supplier<Differentiator>> tempMap = new HashMap<String, Supplier<Differentiator>>();
        tempMap.put("Whole Config", WholeConfigDifferentiator::getByteBufferDifferentiator);
        DIFFERENTIATOR_CONSTRUCTOR_MAP = Collections.unmodifiableMap(tempMap);
        DEFAULT_POLLING_PERIOD_UNIT = TimeUnit.SECONDS;
        logger = LoggerFactory.getLogger(FileChangeIngestor.class);
    }
}

