/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.protocol.component.api;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import org.apache.nifi.c2.protocol.component.api.ComponentManifest;

@ApiModel
public class Bundle
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_GROUP = "default";
    public static final String DEFAULT_ARTIFACT = "unknown";
    public static final String DEFAULT_VERSION = "unversioned";
    private String group;
    private String artifact;
    private String version;
    private ComponentManifest componentManifest;

    public Bundle() {
    }

    public Bundle(String group, String artifact, String version) {
        this.group = group;
        this.artifact = artifact;
        this.version = version;
    }

    public static Bundle defaultBundle() {
        return new Bundle(DEFAULT_GROUP, DEFAULT_ARTIFACT, DEFAULT_VERSION);
    }

    @ApiModelProperty(value="The group id of the bundle", notes="A globally unique group namespace, e.g., org.apache.nifi", required=true)
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    @ApiModelProperty(value="The artifact id of the bundle", notes="Unique within the group", required=true)
    public String getArtifact() {
        return this.artifact;
    }

    public void setArtifact(String artifact) {
        this.artifact = artifact;
    }

    @ApiModelProperty(value="The version of the bundle artifact")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @ApiModelProperty(value="The full specification of the bundle contents", notes="This is optional, as the group, artifact, and version are also enough to reference a bundle in the case the bundle specification has been published to a registry.")
    public ComponentManifest getComponentManifest() {
        return this.componentManifest;
    }

    public void setComponentManifest(ComponentManifest componentManifest) {
        this.componentManifest = componentManifest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bundle bundle = (Bundle)o;
        return Objects.equals(this.group, bundle.group) && Objects.equals(this.artifact, bundle.artifact) && Objects.equals(this.version, bundle.version);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.artifact, this.version);
    }
}

