package javax.portlet.faces.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/** The ExcludeFromManagedRequestScope annotation is used on a class as a signal
 * that instances of this class are not to be managed by the bridge in the bridge
 * request scope if/when the instance is added to the portlet container's request
 * scope.  This annotation is the preferred method for marking a class for such
 * exlcusion and should be used where ever possible over the secondary configuration
 * techniques additional supported.
 */

@Documented
@Inherited
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE})
public @interface ExcludeFromManagedRequestScope {
}
