/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.schedule.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.myfaces.custom.schedule.model.Day;
import org.apache.myfaces.custom.schedule.model.HalfHourInterval;
import org.apache.myfaces.custom.schedule.model.Interval;
import org.apache.myfaces.custom.schedule.model.ScheduleEntry;
import org.apache.myfaces.custom.schedule.util.ScheduleEntryComparator;

public class ScheduleDay
extends Day
implements Serializable,
Comparable {
    private static final long serialVersionUID = 1L;
    private final TreeSet entries = new TreeSet(new ScheduleEntryComparator());

    public ScheduleDay(Date date) {
        this(date, TimeZone.getDefault());
    }

    public ScheduleDay(Date date, TimeZone tz) {
        super(date, tz);
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public boolean addEntry(ScheduleEntry entry) {
        if (entry == null || entry.getStartTime() == null || entry.getEndTime() == null) {
            return false;
        }
        Calendar cal = this.getCalendarInstance(entry.getEndTime());
        cal.add(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date endDate = cal.getTime();
        cal.setTime(entry.getStartTime());
        while (cal.getTime().before(endDate)) {
            if (this.equalsDate(cal.getTime())) {
                this.entries.add(entry);
                return true;
            }
            cal.add(5, 1);
        }
        return false;
    }

    public void clear() {
        this.entries.clear();
    }

    public Iterator iterator() {
        return this.entries.iterator();
    }

    public boolean remove(ScheduleEntry entry) {
        return this.entries.remove(entry);
    }

    public int size() {
        return this.entries.size();
    }

    public int getLastEventHour() {
        Date lastEnd = null;
        for (ScheduleEntry next : this.entries) {
            if (next.isAllDay() || lastEnd != null && !lastEnd.before(next.getEndTime())) continue;
            lastEnd = next.getEndTime();
        }
        if (lastEnd == null) {
            return 0;
        }
        Calendar endTime = this.getCalendarInstance(lastEnd);
        if (endTime.get(12) > 0) {
            endTime.add(11, 1);
        }
        return this.equalsDate(endTime.getTime()) ? endTime.get(11) : 24;
    }

    public int getFirstEventHour() {
        Calendar startTime = null;
        for (ScheduleEntry next : this.entries) {
            if (next.isAllDay()) continue;
            startTime = this.getCalendarInstance(next.getStartTime());
            break;
        }
        if (startTime == null) {
            return 24;
        }
        return this.equalsDate(startTime.getTime()) ? startTime.get(11) : 0;
    }

    public Interval getInterval(Date clickedDate) {
        if (this.getIntervals() != null) {
            for (Interval interval : this.getIntervals()) {
                if (!interval.containsDate(clickedDate)) continue;
                return interval;
            }
        }
        return null;
    }

    public List getIntervals(int startHour, int endHour) {
        Date startTime = this.initDate(this.getDate(), startHour);
        Date endTime = this.initDate(this.getDate(), endHour);
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        Interval last = null;
        if (this.getIntervals() != null) {
            for (Interval interval : this.getIntervals()) {
                if (last != null) {
                    if (!interval.getEndTime().after(last.getEndTime())) continue;
                    if (interval.getStartTime().before(last.getEndTime())) {
                        interval.setStartTime(last.getEndTime());
                    }
                }
                if (interval.getEndTime().before(startTime)) continue;
                if (interval.getStartTime().after(endTime)) break;
                last = last == null ? new HalfHourInterval(this.initDate(this.getDate(), startHour), interval.getStartTime()) : HalfHourInterval.next(last, interval.getStartTime());
                while (last != null && interval.after(last)) {
                    intervals.add(last);
                    last = HalfHourInterval.next(last, interval.getStartTime());
                }
                if (interval.getStartTime().before(startTime)) {
                    interval.setStartTime(startTime);
                }
                if (interval.getEndTime().after(endTime)) {
                    interval.setEndTime(endTime);
                }
                intervals.add(interval);
                last = interval;
            }
        }
        last = last == null ? new HalfHourInterval(this.initDate(this.getDate(), startHour), endTime) : HalfHourInterval.next(last, endTime);
        while (last != null) {
            intervals.add(last);
            last = HalfHourInterval.next(last, endTime);
        }
        return intervals;
    }

    private Date initDate(Date date, int hour) {
        Calendar calendar = this.getCalendarInstance(date);
        calendar.set(11, hour);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }
}

