/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.datalist;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.UserRoleAware;
import org.apache.myfaces.component.html.ext.HtmlDataTableHack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHtmlDataList
extends HtmlDataTableHack
implements UserRoleAware {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.HtmlDataList";
    private static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.List";
    private static Log log = LogFactory.getLog(AbstractHtmlDataList.class);
    private static final int PROCESS_DECODES = 1;
    private static final int PROCESS_VALIDATORS = 2;
    private static final int PROCESS_UPDATES = 3;
    private static final String SKIP_ITERATION_HINT = "javax.faces.visit.SKIP_ITERATION";
    private transient FacesContext _facesContext;

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        this.setRowIndex(-1);
        this.processChildren(context, 1);
        this.setRowIndex(-1);
        try {
            this.decode(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
    }

    @Override
    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        this.setRowIndex(-1);
        this.processChildren(context, 3);
        this.setRowIndex(-1);
        this.checkUpdateModelError(context);
    }

    @Override
    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        this.setRowIndex(-1);
        this.processChildren(context, 2);
        this.setRowIndex(-1);
        this.checkUpdateModelError(context);
    }

    public void processChildren(FacesContext context, int processAction) {
        int last;
        int first = this.getFirst();
        int rows = this.getRows();
        int n = last = rows == 0 ? this.getRowCount() : first + rows;
        if (log.isTraceEnabled()) {
            log.trace((Object)("processing " + this.getChildCount() + " children: starting at " + first + ", ending at " + last));
        }
        for (int rowIndex = first; last == -1 || rowIndex < last; ++rowIndex) {
            this.setRowIndex(rowIndex);
            if (!this.isRowAvailable()) {
                if (!log.isTraceEnabled()) break;
                log.trace((Object)"scrolled past the last row, aborting");
                break;
            }
            for (UIComponent child : this.getChildren()) {
                if (!child.isRendered()) continue;
                this.process(context, child, processAction);
            }
        }
    }

    private void process(FacesContext context, UIComponent component, int processAction) {
        switch (processAction) {
            case 1: {
                component.processDecodes(context);
                break;
            }
            case 2: {
                component.processValidators(context);
                break;
            }
            case 3: {
                component.processUpdates(context);
            }
        }
    }

    @Override
    public void setRowIndex(int rowIndex) {
        super.setRowIndex(rowIndex);
        String rowIndexVar = this.getRowIndexVar();
        String rowCountVar = this.getRowCountVar();
        if (rowIndexVar != null || rowCountVar != null) {
            Map requestMap = FacesContext.getCurrentInstance().getExternalContext().getRequestMap();
            if (rowIndex >= 0) {
                if (rowIndexVar != null) {
                    requestMap.put(this.getRowIndexVar(), new Integer(rowIndex));
                }
                if (rowCountVar != null) {
                    requestMap.put(this.getRowCountVar(), new Integer(this.getRowCount()));
                }
            } else {
                if (rowIndexVar != null) {
                    requestMap.remove(this.getRowIndexVar());
                }
                if (rowCountVar != null) {
                    requestMap.remove(this.getRowCountVar());
                }
            }
        }
    }

    @Override
    protected void restoreDescendantComponentStates(Object state) {
        this.restoreDescendantComponentStates(this.getChildren().iterator(), state, true);
    }

    @Override
    protected Object saveDescendantComponentStates() {
        return this.saveDescendantComponentStates(this.getChildren().iterator(), true);
    }

    @Override
    protected Map<String, Object> saveFullDescendantComponentStates(FacesContext facesContext) {
        return this.saveFullDescendantComponentStates(facesContext, null, this.getChildren().iterator(), true, this.getContainerClientId(facesContext));
    }

    @Override
    protected void restoreFullDescendantComponentStates(FacesContext facesContext, Object initialState) {
        this.restoreFullDescendantComponentStates(facesContext, this.getChildren().iterator(), initialState, true);
    }

    @Override
    protected void restoreFullDescendantComponentDeltaStates(FacesContext facesContext, Map<String, Object> rowState, Object initialState) {
        this.restoreFullDescendantComponentDeltaStates(facesContext, this.getChildren().iterator(), rowState, initialState, true, this.getContainerClientId(facesContext));
    }

    @Override
    protected Collection<Object[]> saveDescendantInitialComponentStates(FacesContext facesContext) {
        return this.saveDescendantInitialComponentStates(facesContext, this.getChildren().iterator(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean invokeOnComponent(FacesContext context, String clientId, ContextCallback callback) throws FacesException {
        if (context == null) throw new NullPointerException();
        if (clientId == null) throw new NullPointerException();
        if (callback == null) {
            throw new NullPointerException();
        }
        String baseClientId = this.getClientId(context);
        boolean returnValue = baseClientId.equals(clientId);
        boolean isCachedFacesContext = this.isTemporalFacesContext();
        if (!isCachedFacesContext) {
            this.setTemporalFacesContext(context);
        }
        this.pushComponentToEL(context, (UIComponent)this);
        try {
            if (returnValue) {
                try {
                    callback.invokeContextCallback(context, (UIComponent)this);
                    boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    throw new FacesException((Throwable)e);
                }
            }
            Iterator it2 = this.getFacets().values().iterator();
            while (!returnValue && it2.hasNext()) {
                returnValue = ((UIComponent)it2.next()).invokeOnComponent(context, clientId, callback);
            }
            if (returnValue) {
                boolean it2 = returnValue;
                return it2;
            }
            if (!clientId.startsWith(baseClientId)) return returnValue;
            char separator = UINamingContainer.getSeparatorChar((FacesContext)context);
            ValueExpression rowKeyVE = this.getValueExpression("rowKey");
            boolean rowKeyFound = false;
            if (rowKeyVE != null) {
                int oldRow = this.getRowIndex();
                try {
                    int rowsToProcess = this.getRows();
                    if (rowsToProcess == 0) {
                        rowsToProcess = this.getRowCount();
                    }
                    int rowIndex = this.getFirst();
                    for (int rowsProcessed = 0; rowsProcessed < rowsToProcess; ++rowsProcessed, ++rowIndex) {
                        this.setRowIndex(rowIndex);
                        if (!this.isRowAvailable()) break;
                        if (!clientId.startsWith(this.getContainerClientId(context))) continue;
                        rowKeyFound = true;
                        break;
                    }
                    if (rowKeyFound) {
                        Iterator it1 = this.getChildren().iterator();
                        while (!returnValue && it1.hasNext()) {
                            returnValue = ((UIComponent)it1.next()).invokeOnComponent(context, clientId, callback);
                        }
                    }
                }
                finally {
                    this.setRowIndex(oldRow);
                }
            }
            if (rowKeyVE != null) return returnValue;
            if (!clientId.matches(baseClientId + separator + "[0-9]+" + separator + ".*")) return returnValue;
            String subId = clientId.substring(baseClientId.length() + 1);
            String clientRow = subId.substring(0, subId.indexOf(separator));
            int oldRow = this.getRowIndex();
            try {
                this.setRowIndex(Integer.parseInt(clientRow));
                if (!this.isRowAvailable()) {
                    boolean it1 = false;
                    return it1;
                }
                Iterator it1 = this.getChildren().iterator();
                while (!returnValue) {
                    if (!it1.hasNext()) return returnValue;
                    returnValue = ((UIComponent)it1.next()).invokeOnComponent(context, clientId, callback);
                }
                return returnValue;
            }
            finally {
                this.setRowIndex(oldRow);
            }
        }
        finally {
            this.popComponentFromEL(context);
            if (!isCachedFacesContext) {
                this.setTemporalFacesContext(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean visitTree(VisitContext context, VisitCallback callback) {
        block23: {
            if (!this.isVisitable(context)) {
                return false;
            }
            boolean isTemporalFacesContext = this.isTemporalFacesContext();
            if (!isTemporalFacesContext) {
                this.setTemporalFacesContext(context.getFacesContext());
            }
            int oldRowIndex = this.getRowIndex();
            this.setRowIndex(-1);
            this.pushComponentToEL(context.getFacesContext(), (UIComponent)this);
            try {
                boolean doVisitChildren;
                VisitResult visitResult = context.invokeVisitCallback((UIComponent)this, callback);
                switch (visitResult) {
                    case COMPLETE: {
                        boolean bl = true;
                        return bl;
                    }
                    case REJECT: {
                        boolean bl = false;
                        return bl;
                    }
                }
                Collection subtreeIdsToVisit = context.getSubtreeIdsToVisit((UIComponent)this);
                boolean bl = doVisitChildren = subtreeIdsToVisit != null && !subtreeIdsToVisit.isEmpty();
                if (!doVisitChildren) break block23;
                for (UIComponent facet : this.getFacets().values()) {
                    if (!facet.visitTree(context, callback)) continue;
                    boolean bl2 = true;
                    return bl2;
                }
                Boolean skipIterationHint = (Boolean)context.getFacesContext().getAttributes().get(SKIP_ITERATION_HINT);
                if (skipIterationHint != null && skipIterationHint.booleanValue()) {
                    if (this.getChildCount() <= 0) break block23;
                    for (UIComponent child : this.getChildren()) {
                        if (!child.visitTree(context, callback)) continue;
                        boolean bl3 = true;
                        return bl3;
                    }
                    break block23;
                }
                int rowsToProcess = this.getRows();
                if (rowsToProcess == 0) {
                    rowsToProcess = this.getRowCount();
                }
                int rowIndex = this.getFirst();
                int rowsProcessed = 0;
                while (rowsProcessed < rowsToProcess) {
                    this.setRowIndex(rowIndex);
                    if (!this.isRowAvailable()) {
                        boolean bl4 = false;
                        return bl4;
                    }
                    for (UIComponent child : this.getChildren()) {
                        if (!child.visitTree(context, callback)) continue;
                        boolean bl5 = true;
                        return bl5;
                    }
                    ++rowsProcessed;
                    ++rowIndex;
                }
            }
            finally {
                this.popComponentFromEL(context.getFacesContext());
                this.setRowIndex(oldRowIndex);
                if (!isTemporalFacesContext) {
                    this.setTemporalFacesContext(null);
                }
            }
        }
        return false;
    }

    protected FacesContext getFacesContext() {
        if (this._facesContext == null) {
            return super.getFacesContext();
        }
        return this._facesContext;
    }

    private boolean isTemporalFacesContext() {
        return this._facesContext != null;
    }

    private void setTemporalFacesContext(FacesContext facesContext) {
        this._facesContext = facesContext;
    }

    public abstract String getRowCountVar();

    public abstract String getRowIndexVar();

    public abstract String getLayout();

    public abstract String getItemStyleClass();

    public abstract String getItemOnClick();
}

