/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation;

import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Named;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.WindowContext;
import org.apache.myfaces.extensions.cdi.core.impl.scope.conversation.spi.WindowContextManager;
import org.apache.myfaces.extensions.cdi.core.impl.util.UnmodifiableMap;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.InjectableConversation;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.EditableConversation;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.EditableWindowContext;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.ExceptionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class WindowBeanProducers {
    @Produces
    @Named(value="currentWindowContext")
    @RequestScoped
    protected EditableWindowContext currentWindowContext(WindowContextManager windowContextManager) {
        WindowContext windowContext = windowContextManager.getCurrentWindowContext();
        if (windowContext instanceof EditableWindowContext) {
            return (EditableWindowContext)windowContext;
        }
        throw ExceptionUtils.windowContextNotEditableException(windowContext);
    }

    @Produces
    @Named(value="currentWindow")
    @RequestScoped
    protected Map<String, Object> currentWindow(final WindowContextManager windowContextManager) {
        return new UnmodifiableMap<String, Object>(){
            private static final long serialVersionUID = 2356468240049980467L;

            public Object get(Object key) {
                if (!(key instanceof String)) {
                    return null;
                }
                String attributeKey = key.toString();
                if ("id".equalsIgnoreCase(attributeKey)) {
                    return windowContextManager.getCurrentWindowContext().getId();
                }
                if ("useNewId".equalsIgnoreCase(key.toString())) {
                    return "";
                }
                return windowContextManager.getCurrentWindowContext().getAttribute(attributeKey, Object.class);
            }
        };
    }

    @Produces
    @Dependent
    protected EditableConversation currentConversation(InjectionPoint injectionPoint, WindowContextManager windowContextManager) {
        return new InjectableConversation(injectionPoint.getBean(), windowContextManager);
    }
}

