/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.flow;

import jakarta.el.ValueExpression;
import jakarta.faces.context.FacesContext;
import jakarta.faces.flow.FlowCallNode;
import jakarta.faces.flow.Parameter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.myfaces.flow.Freezable;

public class FlowCallNodeImpl
extends FlowCallNode
implements Freezable {
    private String _id;
    private String _calledFlowId;
    private ValueExpression _calledFlowIdEL;
    private String _calledFlowDocumentId;
    private ValueExpression _calledFlowDocumentIdEL;
    private Map<String, Parameter> _outboundParametersMap;
    private Map<String, Parameter> _unmodifiableOutboundParametersMap;
    private boolean _initialized;

    public FlowCallNodeImpl(String id) {
        this._id = id;
        this._outboundParametersMap = new HashMap<String, Parameter>();
        this._unmodifiableOutboundParametersMap = Collections.unmodifiableMap(this._outboundParametersMap);
    }

    @Override
    public Map<String, Parameter> getOutboundParameters() {
        return this._unmodifiableOutboundParametersMap;
    }

    public void putOutboundParameter(String key, Parameter value) {
        this.checkInitialized();
        this._outboundParametersMap.put(key, value);
    }

    @Override
    public String getCalledFlowDocumentId(FacesContext context) {
        if (this._calledFlowDocumentIdEL != null) {
            return (String)this._calledFlowDocumentIdEL.getValue(context.getELContext());
        }
        return this._calledFlowDocumentId;
    }

    @Override
    public String getCalledFlowId(FacesContext context) {
        if (this._calledFlowIdEL != null) {
            return (String)this._calledFlowIdEL.getValue(context.getELContext());
        }
        return this._calledFlowId;
    }

    @Override
    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this.checkInitialized();
        this._id = id;
    }

    public void setCalledFlowId(String calledFlowId) {
        this.checkInitialized();
        this._calledFlowId = calledFlowId;
        this._calledFlowIdEL = null;
    }

    public void setCalledFlowDocumentId(String calledFlowDocumentId) {
        this.checkInitialized();
        this._calledFlowDocumentId = calledFlowDocumentId;
        this._calledFlowDocumentIdEL = null;
    }

    @Override
    public void freeze() {
        this._initialized = true;
        for (Map.Entry<String, Parameter> entry : this._outboundParametersMap.entrySet()) {
            if (!(entry.getValue() instanceof Freezable)) continue;
            ((Freezable)((Object)entry.getValue())).freeze();
        }
    }

    private void checkInitialized() throws IllegalStateException {
        if (this._initialized) {
            throw new IllegalStateException("Flow is inmutable once initialized");
        }
    }

    public void setCalledFlowId(ValueExpression calledFlowIdEL) {
        this._calledFlowIdEL = calledFlowIdEL;
        this._calledFlowId = null;
    }

    public void setCalledFlowDocumentId(ValueExpression calledFlowDocumentIdEL) {
        this._calledFlowDocumentIdEL = calledFlowDocumentIdEL;
        this._calledFlowDocumentId = null;
    }
}

