/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.util.List;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.IndexedDiff;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.IterableUtil;

public class ShouldContainExactly
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldContainExactly(Object actual, Iterable<?> expected, Iterable<?> notFound, Iterable<?> notExpected, ComparisonStrategy comparisonStrategy) {
        if (IterableUtil.isNullOrEmpty(notExpected) && IterableUtil.isNullOrEmpty(notFound)) {
            return new ShouldContainExactly(actual, expected, comparisonStrategy);
        }
        if (IterableUtil.isNullOrEmpty(notExpected)) {
            return new ShouldContainExactly(actual, expected, notFound, comparisonStrategy);
        }
        if (IterableUtil.isNullOrEmpty(notFound)) {
            return new ShouldContainExactly(actual, expected, comparisonStrategy, notExpected);
        }
        return new ShouldContainExactly(actual, expected, notFound, notExpected, comparisonStrategy);
    }

    public static ErrorMessageFactory shouldContainExactly(Object actual, Iterable<?> expected, Iterable<?> notFound, Iterable<?> notExpected) {
        return ShouldContainExactly.shouldContainExactly(actual, expected, notFound, notExpected, StandardComparisonStrategy.instance());
    }

    public static ErrorMessageFactory shouldContainExactlyWithIndexes(Object actual, Iterable<?> expected, List<IndexedDiff> indexDifferences, ComparisonStrategy comparisonStrategy) {
        return new ShouldContainExactly(actual, expected, indexDifferences, comparisonStrategy);
    }

    public static ErrorMessageFactory shouldContainExactlyWithIndexes(Object actual, Iterable<?> expected, List<IndexedDiff> indexDifferences) {
        return new ShouldContainExactly(actual, expected, indexDifferences, (ComparisonStrategy)StandardComparisonStrategy.instance());
    }

    private ShouldContainExactly(Object actual, Object expected, ComparisonStrategy comparisonStrategy) {
        super("%nExpecting actual:%n  %s%nto contain exactly (and in same order):%n  %s%n", actual, expected, comparisonStrategy);
    }

    private ShouldContainExactly(Object actual, Object expected, Object notFound, Object notExpected, ComparisonStrategy comparisonStrategy) {
        super("%nExpecting actual:%n  %s%nto contain exactly (and in same order):%n  %s%nbut some elements were not found:%n  %s%nand others were not expected:%n  %s%n%s", actual, expected, notFound, notExpected, comparisonStrategy);
    }

    private ShouldContainExactly(Object actual, Object expected, Object notFound, ComparisonStrategy comparisonStrategy) {
        super("%nExpecting actual:%n  %s%nto contain exactly (and in same order):%n  %s%nbut could not find the following elements:%n  %s%n%s", actual, expected, notFound, comparisonStrategy);
    }

    private ShouldContainExactly(Object actual, Object expected, ComparisonStrategy comparisonStrategy, Object unexpected) {
        super("%nExpecting actual:%n  %s%nto contain exactly (and in same order):%n  %s%nbut some elements were not expected:%n  %s%n%s", actual, expected, unexpected, comparisonStrategy);
    }

    private ShouldContainExactly(Object actual, Object expected, List<IndexedDiff> indexDiffs, ComparisonStrategy comparisonStrategy) {
        super("%nExpecting actual:%n  %s%nto contain exactly (and in same order):%n  %s%n" + ShouldContainExactly.formatIndexDifferences(indexDiffs), actual, expected, comparisonStrategy);
    }

    private static String formatIndexDifferences(List<IndexedDiff> indexedDiffs) {
        StringBuilder sb = new StringBuilder();
        sb.append("but there were differences at these indexes");
        if (indexedDiffs.size() >= 50) {
            sb.append(String.format(" (only showing the first %d mismatches)", 50));
        }
        sb.append(":%n");
        for (IndexedDiff diff : indexedDiffs) {
            sb.append(String.format("  - element at index %d: expected \"%s\" but was \"%s\"%n", diff.index, diff.expected, diff.actual));
        }
        return sb.toString();
    }

    public static ErrorMessageFactory elementsDifferAtIndex(Object actualElement, Object expectedElement, int indexOfDifferentElements, ComparisonStrategy comparisonStrategy) {
        return new ShouldContainExactly(actualElement, expectedElement, indexOfDifferentElements, comparisonStrategy);
    }

    public static ErrorMessageFactory elementsDifferAtIndex(Object actualElement, Object expectedElement, int indexOfDifferentElements) {
        return new ShouldContainExactly(actualElement, expectedElement, indexOfDifferentElements, (ComparisonStrategy)StandardComparisonStrategy.instance());
    }

    private ShouldContainExactly(Object actualElement, Object expectedElement, int indexOfDifferentElements, ComparisonStrategy comparisonStrategy) {
        super("%nActual and expected have the same elements but not in the same order, at index %s actual element was:%n  %s%nwhereas expected element was:%n  %s%n%s", indexOfDifferentElements, actualElement, expectedElement, comparisonStrategy);
    }
}

