/*
 * Decompiled with CFR 0.152.
 */
package edu.usc.ir.sentiment.analysis.cmdline;

import java.io.File;
import java.io.IOException;
import opennlp.tools.cmdline.AbstractTrainerTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.TrainingToolParams;
import opennlp.tools.sentiment.SentimentFactory;
import opennlp.tools.sentiment.SentimentME;
import opennlp.tools.sentiment.SentimentModel;
import opennlp.tools.sentiment.SentimentSample;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.model.BaseModel;
import opennlp.tools.util.model.ModelUtil;

public class SentimentTrainerTool
extends AbstractTrainerTool<SentimentSample, TrainingToolParams> {
    protected SentimentTrainerTool() {
        super(SentimentSample.class, TrainingToolParams.class);
    }

    public void run(String format, String[] args) {
        super.run(format, args);
        if (0 == args.length) {
            System.out.println(this.getHelp());
        } else {
            SentimentModel model;
            this.mlParams = CmdLineUtil.loadTrainingParameters((String)((TrainingToolParams)this.params).getParams(), (boolean)false);
            if (this.mlParams == null) {
                this.mlParams = ModelUtil.createDefaultTrainingParameters();
            }
            File modelOutFile = ((TrainingToolParams)this.params).getModel();
            CmdLineUtil.checkOutputFile((String)"sentiment analysis model", (File)modelOutFile);
            try {
                SentimentFactory factory = new SentimentFactory();
                model = SentimentME.train(((TrainingToolParams)this.params).getLang(), (ObjectStream<SentimentSample>)this.sampleStream, this.mlParams, factory);
            }
            catch (IOException e) {
                throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    this.sampleStream.close();
                }
                catch (IOException e) {}
            }
            CmdLineUtil.writeModel((String)"sentiment analysis", (File)modelOutFile, (BaseModel)model);
        }
    }

    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " model < documents";
    }

    public String getShortDescription() {
        return "learnable sentiment analysis";
    }
}

