/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ArgumentDeclaration;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.MixinReference;
import com.github.sommeri.less4j.core.ast.ReusableStructure;
import com.github.sommeri.less4j.core.compiler.expressions.ExpressionManipulator;
import com.github.sommeri.less4j.core.compiler.scopes.IScope;
import com.github.sommeri.less4j.core.compiler.scopes.ScopeFactory;
import com.github.sommeri.less4j.core.compiler.stages.EvaluatedMixinReferenceCall;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class ArgumentsBuilder {
    private final ProblemsHandler problemsHandler;
    private final ExpressionManipulator expressionManipulator = new ExpressionManipulator();
    private final String ALL_ARGUMENTS = "@arguments";
    private Iterator<Expression> positionalParameters;
    private ReusableStructure mixin;
    private EvaluatedMixinReferenceCall evaluatedReference;
    private MixinReference reference;
    private List<Expression> allValues = new ArrayList<Expression>();
    private IScope argumentsScope;

    public ArgumentsBuilder(EvaluatedMixinReferenceCall evaluatedReference, ReusableStructure pureMixin, ProblemsHandler problemsHandler) {
        this.problemsHandler = problemsHandler;
        this.positionalParameters = evaluatedReference.getPositionalParameters().iterator();
        this.evaluatedReference = evaluatedReference;
        this.reference = evaluatedReference.getReference();
        this.argumentsScope = ScopeFactory.createDummyScope(this.reference, "#arguments-" + this.reference + "#");
        this.mixin = pureMixin;
    }

    public IScope build() {
        int length = this.mixin.getParameters().size();
        for (int i = 0; i < length; ++i) {
            ASTCssNode parameter = this.mixin.getParameters().get(i);
            if (parameter.getType() == ASTCssNodeType.ARGUMENT_DECLARATION) {
                this.add((ArgumentDeclaration)parameter);
                continue;
            }
            this.skipPositionalParameter();
        }
        Expression allArgumentsValue = this.expressionManipulator.joinAll(this.allValues, this.reference);
        this.argumentsScope.registerVariableIfNotPresent("@arguments", allArgumentsValue);
        return this.argumentsScope;
    }

    private void skipPositionalParameter() {
        this.positionalParameters.next();
    }

    private void add(ArgumentDeclaration declaration) {
        if (this.canFillFromNamed(declaration)) {
            this.fillFromNamed(declaration);
        } else if (declaration.isCollector()) {
            this.addAsCollector(declaration);
        } else if (this.canFillFromPositional()) {
            this.fillFromPositional(declaration);
        } else if (this.hasDefault(declaration)) {
            this.fillFromDefault(declaration);
        } else if (declaration.getValue() == null) {
            this.problemsHandler.undefinedMixinParameterValue(this.mixin, declaration, this.reference);
        }
    }

    private void fillFromNamed(ArgumentDeclaration declaration) {
        Expression value = this.evaluatedReference.getNamedParameter(declaration.getVariable());
        this.allValues.add(value);
        this.argumentsScope.registerVariable(declaration, value);
    }

    private boolean canFillFromNamed(ArgumentDeclaration declaration) {
        return this.evaluatedReference.hasNamedParameter(declaration.getVariable());
    }

    private void fillFromDefault(ArgumentDeclaration declaration) {
        this.allValues.add(declaration.getValue());
        this.argumentsScope.registerVariable(declaration);
    }

    private boolean hasDefault(ArgumentDeclaration declaration) {
        return declaration.getValue() != null;
    }

    private void fillFromPositional(ArgumentDeclaration declaration) {
        Expression value = this.positionalParameters.next();
        this.allValues.add(value);
        this.argumentsScope.registerVariable(declaration, value);
    }

    private boolean canFillFromPositional() {
        return this.positionalParameters.hasNext();
    }

    private void addAsCollector(ArgumentDeclaration declaration) {
        List<Expression> allArgumentsFrom = ArraysUtils.remaining(this.positionalParameters);
        this.allValues.addAll(allArgumentsFrom);
        Expression value = this.expressionManipulator.joinAll(allArgumentsFrom, this.reference);
        this.argumentsScope.registerVariable(declaration, value);
    }
}

