/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.config;

import java.util.Iterator;
import java.util.Locale;
import java.util.ServiceLoader;
import org.apache.knox.gateway.config.ConfigurationAdapter;
import org.apache.knox.gateway.config.ConfigurationBinding;
import org.apache.knox.gateway.config.ConfigurationException;
import org.apache.knox.gateway.config.impl.ConfigurationAdapterFactory;
import org.apache.knox.gateway.config.impl.DefaultConfigurationBinding;
import org.apache.knox.gateway.config.impl.MappedConfigurationBinding;
import org.apache.knox.gateway.config.spi.ConfigurationInjector;

public class ConfigurationInjectorBuilder {
    private static ConfigurationBinding DEFAULT_BINDING = new DefaultConfigurationBinding();
    private static ConfigurationInjector INSTANCE;
    private Object target;
    private ConfigurationAdapter source;
    private ConfigurationBinding binding;

    private static synchronized ConfigurationInjector getInjector() {
        if (INSTANCE == null) {
            INSTANCE = ConfigurationInjectorBuilder.createInjector();
        }
        return INSTANCE;
    }

    private static synchronized ConfigurationInjector createInjector() {
        Iterator<ConfigurationInjector> iterator;
        ConfigurationInjector injector = null;
        ServiceLoader<ConfigurationInjector> loader = ServiceLoader.load(ConfigurationInjector.class);
        if (loader != null && (iterator = loader.iterator()) != null && iterator.hasNext()) {
            injector = iterator.next();
        }
        if (injector == null) {
            throw new ConfigurationException(String.format(Locale.ROOT, "Failed to load an implementation of %s", ConfigurationInjector.class.getName()));
        }
        return injector;
    }

    public static ConfigurationInjectorBuilder configuration() {
        return new ConfigurationInjectorBuilder();
    }

    public ConfigurationInjectorBuilder target(Object target) {
        this.target = target;
        return this;
    }

    public ConfigurationInjectorBuilder source(Object source) {
        this.source = ConfigurationAdapterFactory.get(source);
        return this;
    }

    public ConfigurationInjectorBuilder source(ConfigurationAdapter adapter) {
        this.source = adapter;
        return this;
    }

    public ConfigurationInjectorBuilder binding(ConfigurationBinding binding) {
        this.binding = binding;
        return this;
    }

    public ConfigurationInjectorBuilder bind(String targetName, String sourceName) {
        ((MappedConfigurationBinding)this.binding()).bind(targetName, sourceName);
        return this;
    }

    public ConfigurationBinding binding() {
        if (this.binding == null) {
            this.binding = new MappedConfigurationBinding();
        }
        return this.binding;
    }

    public void inject() throws ConfigurationException {
        ConfigurationInjector injector = ConfigurationInjectorBuilder.getInjector();
        if (this.binding == null) {
            this.binding = DEFAULT_BINDING;
        }
        injector.configure(this.target, this.source, this.binding);
    }
}

