/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.features.paging;

import javax.ws.rs.core.UriInfo;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.exceptions.JPARSException;
import org.eclipse.persistence.jpa.rs.features.paging.AbstractPagingValidator;

public final class PageableQueryValidator
extends AbstractPagingValidator {
    private final PersistenceContext context;
    private final String queryName;

    public PageableQueryValidator(PersistenceContext context, String queryName, UriInfo uri) {
        super(uri);
        this.context = context;
        this.queryName = queryName;
    }

    @Override
    public boolean isFeatureApplicable() throws JPARSException {
        if (this.context.isQueryPageable(this.queryName)) {
            this.checkParameters(this.context.getPageableQuery(this.queryName).limit());
            return true;
        }
        if (this.queryParameters.containsKey("limit") || this.queryParameters.containsKey("offset")) {
            throw JPARSException.paginationParameterForNotPageableResource();
        }
        return false;
    }
}

