/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.tool.xmlsectool;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.PrintStream;
import java.util.List;
import net.shibboleth.tool.xmlsectool.Blacklist;
import net.shibboleth.tool.xmlsectool.DigestChoice;
import net.shibboleth.tool.xmlsectool.ReturnCode;
import net.shibboleth.tool.xmlsectool.Terminator;

public class CommandLineArguments {
    private static final String OPT = "--";
    private static final String HELP_ARG = "help";
    private static final String SIGN_ARG = "sign";
    private static final String V_SIG_ARG = "verifySignature";
    private static final String V_SCHEMA_ARG = "validateSchema";
    private static final String IN_FILE_ARG = "inFile";
    private static final String IN_URL_ARG = "inUrl";
    private static final String BASE64_IN_ARG = "base64DecodeInput";
    private static final String BASE64_OUT_ARG = "base64EncodeOutput";
    private static final String INFLATE_IN_ARG = "inflateInput";
    private static final String GUNZIP_IN_ARG = "gunzipInput";
    private static final String HTTP_PROXY_ARG = "httpProxy";
    private static final String HTTP_PROXY_PORT_ARG = "httpProxyPort";
    private static final String HTTP_PROXY_USERNAME_ARG = "httpProxyUsername";
    private static final String HTTP_PROXY_PASSWORD_ARG = "httpProxyPassword";
    private static final String SCHEMA_XSD_LANG_ARG = "xsd";
    private static final String SCHEMA_RNG_LANG_ARG = "relaxng";
    private static final String SCHEMA_DIR_ARG = "schemaDirectory";
    private static final String SIG_REF_ID_ATT_ARG = "referenceIdAttributeName";
    private static final String SIG_POS_ARG = "signaturePosition";
    private static final String DIGEST_ARG = "digest";
    private static final String DIGEST_ALGORITHM_ARG = "digestAlgorithm";
    private static final String SIGNATURE_ALGORITHM_ARG = "signatureAlgorithm";
    private static final String KI_KEY_NAME_ARG = "keyInfoKeyName";
    private static final String KI_CRL_ARG = "keyInfoCRL";
    private static final String CERT_ARG = "certificate";
    private static final String KEY_ARG = "key";
    private static final String KEY_PASSWORD_ARG = "keyPassword";
    private static final String KEYSTORE_ARG = "keystore";
    private static final String KEYSTORE_PASSWORD_ARG = "keystorePassword";
    private static final String KEYSTORE_TYPE_ARG = "keystoreType";
    private static final String KEYSTORE_PROVIDER_ARG = "keystoreProvider";
    private static final String PKCS11_CONFIG_ARG = "pkcs11Config";
    private static final String CLEAR_BLACKLIST_ARG = "clearBlacklist";
    private static final String BLACKLIST_DIGEST_ARG = "blacklistDigest";
    private static final String WHITELIST_DIGEST_ARG = "whitelistDigest";
    private static final String LIST_BLACKLIST_ARG = "listBlacklist";
    private static final String OUT_FILE_ARG = "outFile";
    private static final String DEFLATE_OUT_ARG = "deflateOutput";
    private static final String GZIP_OUT_ARG = "gzipOutput";
    private static final String VERBOSE_ARG = "verbose";
    private static final String QUIET_ARG = "quiet";
    private static final String LOG_CONFIG_ARG = "logConfig";
    @Parameter(names={"--sign"})
    private boolean sign;
    @Parameter(names={"--validateSchema"})
    private boolean schemaValidate;
    @Parameter(names={"--verifySignature"})
    private boolean signatureVerify;
    @Parameter(names={"--inFile"})
    private String inFile;
    @Parameter(names={"--inUrl"})
    private String inUrl;
    @Parameter(names={"--base64DecodeInput"})
    private boolean base64DecodeInput;
    @Parameter(names={"--inflateInput"})
    private boolean inflateInput;
    @Parameter(names={"--gunzipInput"})
    private boolean gunzipInput;
    @Parameter(names={"--httpProxy"})
    private String httpProxy;
    @Parameter(names={"--httpProxyPort"})
    private int httpProxyPort = 80;
    @Parameter(names={"--httpProxyUsername"})
    private String httpProxyUsername;
    @Parameter(names={"--httpProxyPassword"})
    private String httpProxyPassword;
    @Parameter(names={"--schemaDirectory"})
    private String schemaDirectory;
    @Parameter(names={"--xsd"})
    private boolean xsdSchema;
    @Parameter(names={"--relaxng"})
    private boolean rngSchema;
    @Parameter(names={"--referenceIdAttributeName"})
    private String refIdAttributeName;
    @Parameter(names={"--signaturePosition"})
    private String signaturePosition;
    private DigestChoice digest;
    @Parameter(names={"--digest"})
    private String digestName;
    @Parameter(names={"--digestAlgorithm"})
    private String digestAlgorithm;
    @Parameter(names={"--signatureAlgorithm"})
    private String signatureAlgorithm;
    @Parameter(names={"--keyInfoKeyName"})
    private List<String> kiKeyNames;
    @Parameter(names={"--keyInfoCRL"})
    private List<String> kiCrls;
    @Parameter(names={"--outFile"})
    private String outFile;
    @Parameter(names={"--base64EncodeOutput"})
    private boolean base64EncodeOutput;
    @Parameter(names={"--deflateOutput"})
    private boolean deflateOutput;
    @Parameter(names={"--gzipOutput"})
    private boolean gzipOutput;
    @Parameter(names={"--certificate"})
    private String cert;
    @Parameter(names={"--key"})
    private String key;
    @Parameter(names={"--keyPassword"})
    private String keyPassword;
    @Parameter(names={"--keystore"})
    private String keystore;
    @Parameter(names={"--keystorePassword"})
    private String keystorePassword;
    @Parameter(names={"--keystoreType"})
    private String keystoreType;
    @Parameter(names={"--keystoreProvider"})
    private String keystoreProvider;
    @Parameter(names={"--pkcs11Config"})
    private String pkcs11Config;
    private final Blacklist blacklist = new Blacklist();
    @Parameter(names={"--clearBlacklist"})
    private boolean clearBlacklist;
    @Parameter(names={"--listBlacklist"})
    private boolean listBlacklist;
    @Parameter(names={"--blacklistDigest"})
    private List<String> blacklistDigestNames;
    @Parameter(names={"--whitelistDigest"})
    private List<String> whitelistDigestNames;
    @Parameter(names={"--verbose"})
    private boolean verbose;
    @Parameter(names={"--quiet"})
    private boolean quiet;
    @Parameter(names={"--logConfig"})
    private String logConfig;
    @Parameter(names={"help"}, help=true)
    private boolean help;

    public void parseCommandLineArguments(String[] args) {
        try {
            JCommander jc = new JCommander((Object)this);
            jc.parse(args);
            if (!this.xsdSchema && !this.rngSchema) {
                this.xsdSchema = true;
            }
            this.validateCommandLineArguments();
            this.processBlacklistOptions();
        }
        catch (ParameterException e) {
            this.errorAndExit(e.getMessage());
        }
    }

    private void processBlacklistOptions() {
        DigestChoice dig;
        if (this.clearBlacklist) {
            this.blacklist.clear();
        }
        if (this.blacklistDigestNames != null) {
            for (String name : this.blacklistDigestNames) {
                dig = DigestChoice.find(name);
                if (dig == null) {
                    this.errorAndExit("digest choice \"" + name + "\" was not recognised");
                }
                this.blacklist.addDigest(dig);
            }
        }
        if (this.whitelistDigestNames != null) {
            for (String name : this.whitelistDigestNames) {
                dig = DigestChoice.find(name);
                if (dig == null) {
                    this.errorAndExit("digest choice \"" + name + "\" was not recognised");
                }
                this.blacklist.removeDigest(dig);
            }
        }
    }

    public String getHttpProxy() {
        return this.httpProxy;
    }

    public int getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public String getHttpProxyUsername() {
        return this.httpProxyUsername;
    }

    public String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    public boolean doSign() {
        return this.sign;
    }

    public boolean doSchemaValidation() {
        return this.schemaValidate;
    }

    public boolean doSignatureVerify() {
        return this.signatureVerify;
    }

    public String getReferenceIdAttributeName() {
        return this.refIdAttributeName;
    }

    public String getSignaturePosition() {
        return this.signaturePosition;
    }

    public DigestChoice getDigest() {
        return this.digest;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public List<String> getKeyInfoKeyNames() {
        return this.kiKeyNames;
    }

    public List<String> getKeyInfoCrls() {
        return this.kiCrls;
    }

    public String getInputFile() {
        return this.inFile;
    }

    public String getInputUrl() {
        return this.inUrl;
    }

    public boolean isBase64DecodeInput() {
        return this.base64DecodeInput;
    }

    public boolean isInflateInput() {
        return this.inflateInput;
    }

    public boolean isGunzipInput() {
        return this.gunzipInput;
    }

    public String getSchemaDirectory() {
        return this.schemaDirectory;
    }

    public boolean isXsdSchema() {
        return this.xsdSchema;
    }

    public boolean isRngSchema() {
        return this.rngSchema;
    }

    public String getOutputFile() {
        return this.outFile;
    }

    public boolean isBase64EncodedOutput() {
        return this.base64EncodeOutput;
    }

    public boolean isDeflateOutput() {
        return this.deflateOutput;
    }

    public boolean isGzipOutput() {
        return this.gzipOutput;
    }

    public String getCertificate() {
        return this.cert;
    }

    public String getKey() {
        return this.key;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public String getKeystore() {
        return this.keystore;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public String getKeystoreProvider() {
        return this.keystoreProvider;
    }

    public String getPkcs11Config() {
        return this.pkcs11Config;
    }

    public Blacklist getBlacklist() {
        return this.blacklist;
    }

    public boolean doListBlacklist() {
        return this.listBlacklist;
    }

    public boolean doVerboseOutput() {
        return this.verbose;
    }

    public boolean doQuietOutput() {
        return this.quiet;
    }

    public String getLoggingConfiguration() {
        return this.logConfig;
    }

    public boolean doHelp() {
        return this.help;
    }

    private void validateCommandLineArguments() {
        if (this.doHelp()) {
            return;
        }
        if (this.doListBlacklist()) {
            return;
        }
        if (!(this.doSchemaValidation() || this.doSignatureVerify() || this.doSign())) {
            this.errorAndExit("No action was specified");
        }
        if (this.getInputFile() == null && this.getInputUrl() == null || this.getInputFile() != null && this.getInputUrl() != null) {
            this.errorAndExit("One, and only one, document input method must be specified");
        }
        if (this.isInflateInput() && this.isGunzipInput()) {
            this.errorAndExit("Options " + INFLATE_IN_ARG + " and " + GUNZIP_IN_ARG + " are mutually exclusive");
        }
        if (this.doSchemaValidation()) {
            if (this.getSchemaDirectory() == null) {
                this.errorAndExit("schemaDirectory option is required");
            }
            if (this.isXsdSchema() && this.isRngSchema()) {
                this.errorAndExit("XML Schema and RelaxNG languages may not be used simultaneously");
            }
        }
        if (this.doSign() && this.doSignatureVerify()) {
            this.errorAndExit("The signing and signature verification actions are mutually exclusive");
        }
        if ((this.doSign() || this.doSignatureVerify()) && this.getCertificate() == null && this.getPkcs11Config() == null && this.getKeystore() == null) {
            this.errorAndExit("No credential source was given, unable to perform signature operation");
        }
        if (this.digestName != null) {
            this.digest = DigestChoice.find(this.digestName);
            if (this.digest == null) {
                this.errorAndExit("digest choice \"" + this.digestName + "\" was not recognised");
            }
        } else {
            this.digest = DigestChoice.SHA256;
        }
        if (this.doSign()) {
            if (this.getKey() == null) {
                this.errorAndExit("key option is required");
            }
            if ((this.getKeystore() != null || this.getPkcs11Config() != null) && this.getKeyPassword() == null) {
                this.errorAndExit("keyPassword option is required");
            }
            if (this.getOutputFile() == null) {
                this.errorAndExit("No output location specified");
            }
        }
        if (this.isDeflateOutput() && this.isGzipOutput()) {
            this.errorAndExit("Options " + DEFLATE_OUT_ARG + " and " + GZIP_OUT_ARG + " are mutually exclusive");
        }
        if (this.doVerboseOutput() && this.doQuietOutput()) {
            this.errorAndExit("Verbose and quiet output are mutually exclusive");
        }
    }

    public void printHelp(PrintStream out) {
        out.println("XML Security Tool");
        out.println("Provides a command line interface for schema validating, signing, and signature validating an XML file.");
        out.println();
        out.println("==== Command Line Options ====");
        out.println();
        out.println(String.format("  --%-20s %s", HELP_ARG, "Prints this help information"));
        out.println();
        out.println("Action Options - 'sign' and 'verifySignature' are mutually exclusive.  At least one option is required.");
        out.println(String.format("  --%-20s %s", V_SCHEMA_ARG, "Schema validate the document."));
        out.println(String.format("  --%-20s %s", SIGN_ARG, "Sign the XML document."));
        out.println(String.format("  --%-20s %s", V_SIG_ARG, "Check the signature on a signed document."));
        out.println();
        out.println("Data Input Options - 'inFile' and 'inUrl' are mutually exclusive, one is required.");
        out.println(String.format("  --%-20s %s", IN_FILE_ARG, "Specifies the file from which the XML document will be read."));
        out.println(String.format("  --%-20s %s", IN_URL_ARG, "Specifies the URL from which the XML document will be read. HTTPS certificates are not validated."));
        out.println(String.format("  --%-20s %s", BASE64_IN_ARG, "Base64 decodes input.  Useful when reading in data produced with the base64EncodeOutput option"));
        out.println(String.format("  --%-20s %s", INFLATE_IN_ARG, "Inflates a file created with the \"deflate\" compression algorithm.  This property is ignored if inUrl is used.  Instead the returned headers determine if content was deflated"));
        out.println(String.format("  --%-20s %s", GUNZIP_IN_ARG, "Inflates a file created with the \"gzip\" compression algorithm.  This property is ignored if inUrl is used.  Instead the returned headers determine if content was gzip'ed"));
        out.println(String.format("  --%-20s %s", HTTP_PROXY_ARG, "HTTP proxy address used when fetching URL-based input files."));
        out.println(String.format("  --%-20s %s", HTTP_PROXY_PORT_ARG, "HTTP proxy port. (default: 80)"));
        out.println(String.format("  --%-20s %s", HTTP_PROXY_USERNAME_ARG, "Username used to authenticate to the HTTP proxy."));
        out.println(String.format("  --%-20s %s", HTTP_PROXY_PASSWORD_ARG, "Password used to authenticate to the HTTP proxy."));
        out.println();
        out.println("Schema Validation Option - 'xsd' (default) and 'relaxng' are mutually exclusive option.");
        out.println(String.format("  --%-20s %s", SCHEMA_DIR_ARG, "Specifies a schema file or directory of schema files.  Subdirectories are also read."));
        out.println(String.format("  --%-20s %s", SCHEMA_XSD_LANG_ARG, "Indicates schema files are W3 XML Schema 1.0 files (.xsd)."));
        out.println(String.format("  --%-20s %s", SCHEMA_RNG_LANG_ARG, "Indicates schema files are OASIS RELAX NG files (.rng)."));
        out.println();
        out.println("Signature Creation Options");
        out.println(String.format("  --%-20s %s", SIG_REF_ID_ATT_ARG, "Specifies the name of the attribute on the document element whose value is used as the URI reference of the signature.  If omitted, a null reference URI is used."));
        out.println(String.format("  --%-20s %s", SIG_POS_ARG, "Specifies, by 1-based index, which element to place the signature BEFORE.  'FIRST' may be used to indicate that the signature goes BEFORE the first element. 'LAST' may be used to indicate that the signature goes AFTER the last element. (default value: FIRST)"));
        out.println(String.format("  --%-20s %s", DIGEST_ARG, "Specifies the name of the digest algorithm to use: SHA-1, SHA-256 (default), SHA-384, SHA-512.  For RSA and EC credentials, dictates both the digest and signature algorithms."));
        out.println(String.format("  --%-20s %s", DIGEST_ALGORITHM_ARG, "Specifies the URI of the digest algorithm to use; overrides --digest."));
        out.println(String.format("  --%-20s %s", SIGNATURE_ALGORITHM_ARG, "Specifies the URI of the signature algorithm to use; overrides --digest."));
        out.println(String.format("  --%-20s %s", KI_KEY_NAME_ARG, "Specifies a key name to be included in the key info.  Option may be used more than once."));
        out.println(String.format("  --%-20s %s", KI_CRL_ARG, "Specifies a file path for a CRL to be included in the key info.  Option may be used more than once."));
        out.println();
        out.println("PEM/DER Encoded Certificate/Key Options - these options are mutually exclusive with the Keystore and PKCS#11 options. The 'certificate' option is required for signature verification. The 'certificate' and 'key' options are required for signing.");
        out.println(String.format("  --%-20s %s", CERT_ARG, "Specifies the file from which the signing, or validation, certificate is read."));
        out.println(String.format("  --%-20s %s", KEY_ARG, "Specifies the file from which the signing key is read."));
        out.println(String.format("  --%-20s %s", KEY_PASSWORD_ARG, "Specifies the password for the signing key."));
        out.println();
        out.println("Keystore Certificate/Key Options - these options are mutually exclusive with the PEM/DER and PKCS#11 options. Options 'keystore', 'key', and 'keyPassword' are required.");
        out.println(String.format("  --%-20s %s", KEYSTORE_ARG, "Specifies the keystore file."));
        out.println(String.format("  --%-20s %s", KEYSTORE_PASSWORD_ARG, "Specifies the password for the keystore. If not provided then the key password is used."));
        out.println(String.format("  --%-20s %s", KEYSTORE_TYPE_ARG, "Specifies the type of the keystore."));
        out.println(String.format("  --%-20s %s", KEYSTORE_PROVIDER_ARG, "Specifies the keystore provider class to use instead of the default one for the JVM."));
        out.println(String.format("  --%-20s %s", KEY_ARG, "Specifies the key alias for the signing key is read."));
        out.println(String.format("  --%-20s %s", KEY_PASSWORD_ARG, "Specifies the password for the signing key. Keystore password used if none is given."));
        out.println();
        out.println("PKCS#11 Device Certificate/Key Options - these options are mutually exclusive with the PEM/DER and Keystore options. Options 'pkcs11Config' and 'key' are required. Option 'keyPassword' required when signing and, with some PKCS#11 devices, during signature verification.");
        out.println(String.format("  --%-20s %s", PKCS11_CONFIG_ARG, "The PKCS#11 token configuration file."));
        out.println(String.format("  --%-20s %s", KEY_ARG, "Specifies the key alias for the signing key is read."));
        out.println(String.format("  --%-20s %s", KEY_PASSWORD_ARG, "Specifies the pin for the signing key."));
        out.println(String.format("  --%-20s %s", KEYSTORE_PROVIDER_ARG, "The fully qualified class name of the PKCS#11 keystore provider implementation. (e.g., sun.security.pkcs11.SunPKCS11)"));
        out.println();
        out.println("Signature verification algorithm blacklist options:");
        out.println(String.format("  --%-20s %s", CLEAR_BLACKLIST_ARG, "Clear the algorithm blacklist."));
        out.println(String.format("  --%-20s %s", BLACKLIST_DIGEST_ARG, "Blacklist a digest by name (e.g., \"SHA-1\").  Can be used any number of times."));
        out.println(String.format("  --%-20s %s", WHITELIST_DIGEST_ARG, "Whitelist a digest by name (e.g., \"SHA-1\").  Can be used any number of times."));
        out.println(String.format("  --%-20s %s", LIST_BLACKLIST_ARG, "List the contents of the algorithm blacklist."));
        out.println();
        out.println("Data Output Options - Option 'outFile' is required.");
        out.println(String.format("  --%-20s %s", OUT_FILE_ARG, "Specifies the file to which the signed XML document will be written."));
        out.println(String.format("  --%-20s %s", BASE64_OUT_ARG, "Base64 encode the output. Ensures signed content isn't corrupted."));
        out.println(String.format("  --%-20s %s", DEFLATE_OUT_ARG, "Deflate compresses the output."));
        out.println(String.format("  --%-20s %s", GZIP_OUT_ARG, "GZip compresses the output."));
        out.println();
        out.println("Logging Options - these options are mutually exclusive");
        out.println(String.format("  --%-20s %s", VERBOSE_ARG, "Turn on verbose messages."));
        out.println(String.format("  --%-20s %s", QUIET_ARG, "Do not write any messages to STDERR or STDOUT."));
        out.println(String.format("  --%-20s %s", LOG_CONFIG_ARG, "Specifies a logback configuration file to use to configure logging."));
        out.println();
    }

    private void errorAndExit(String error) {
        System.err.println(error);
        System.err.flush();
        System.out.println();
        this.printHelp(System.out);
        System.out.flush();
        throw new Terminator(ReturnCode.RC_INIT);
    }
}

