/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import java.util.ArrayList;
import java.util.List;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.oauth.client.OAuth20Client;
import org.pac4j.oauth.profile.wechat.WechatProfileCreator;
import org.pac4j.oauth.profile.wechat.WechatProfileDefinition;
import org.pac4j.scribe.builder.api.WechatApi20;

public class WechatClient
extends OAuth20Client {
    protected List<WechatScope> scopes;

    public WechatClient() {
    }

    public WechatClient(String key, String secret) {
        this.setKey(key);
        this.setSecret(secret);
    }

    @Override
    protected void clientInit() {
        this.configuration.setApi(new WechatApi20());
        this.configuration.setScope(this.getOAuthScope());
        this.configuration.setProfileDefinition(new WechatProfileDefinition());
        this.configuration.setWithState(true);
        this.defaultProfileCreator(new WechatProfileCreator(this.configuration, (IndirectClient)this));
        super.clientInit();
    }

    protected String getOAuthScope() {
        StringBuilder builder = null;
        if (this.scopes == null || this.scopes.isEmpty()) {
            this.scopes = new ArrayList<WechatScope>();
            this.scopes.add(WechatScope.SNSAPI_BASE);
        }
        if (this.scopes != null) {
            for (WechatScope value : this.scopes) {
                if (builder == null) {
                    builder = new StringBuilder();
                } else {
                    builder.append(",");
                }
                builder.append(value.toString().toLowerCase());
            }
        }
        return builder == null ? null : builder.toString();
    }

    public List<WechatScope> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<WechatScope> scopes) {
        this.scopes = scopes;
    }

    public void addScope(WechatScope scopes) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<WechatScope>();
        }
        this.scopes.add(scopes);
    }

    public static enum WechatScope {
        SNSAPI_LOGIN,
        SNSAPI_BASE,
        SNSAPI_USERINFO;

    }
}

