/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.support;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.spec.KeySpec;
import org.springframework.util.Assert;
import org.springframework.util.Base64Utils;
import org.springframework.vault.VaultException;
import org.springframework.vault.support.Certificate;
import org.springframework.vault.support.KeystoreUtil;

public class CertificateBundle
extends Certificate {
    private final String privateKey;

    CertificateBundle(@JsonProperty(value="serial_number") String serialNumber, @JsonProperty(value="certificate") String certificate, @JsonProperty(value="issuing_ca") String issuingCaCertificate, @JsonProperty(value="private_key") String privateKey) {
        super(serialNumber, certificate, issuingCaCertificate);
        this.privateKey = privateKey;
    }

    public static CertificateBundle of(String serialNumber, String certificate, String issuingCaCertificate, String privateKey) {
        Assert.hasText((String)serialNumber, (String)"Serial number must not be empty");
        Assert.hasText((String)certificate, (String)"Certificate must not be empty");
        Assert.hasText((String)issuingCaCertificate, (String)"Issuing CA certificate must not be empty");
        Assert.hasText((String)privateKey, (String)"Private key must not be empty");
        return new CertificateBundle(serialNumber, certificate, issuingCaCertificate, privateKey);
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public KeySpec getPrivateKeySpec() {
        try {
            byte[] bytes = Base64Utils.decodeFromString((String)this.getPrivateKey());
            return KeystoreUtil.getRSAPrivateKeySpec(bytes);
        }
        catch (IOException e) {
            throw new VaultException("Cannot create KeySpec from private key", e);
        }
    }

    public KeyStore createKeyStore(String keyAlias) {
        Assert.hasText((String)keyAlias, (String)"Key alias must not be empty");
        try {
            return KeystoreUtil.createKeyStore(keyAlias, this.getPrivateKeySpec(), this.getX509Certificate(), this.getX509IssuerCertificate());
        }
        catch (IOException | GeneralSecurityException e) {
            throw new VaultException("Cannot create KeyStore", e);
        }
    }
}

