/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.hdfs;

import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;
import org.apache.knox.gateway.shell.AbstractRequest;
import org.apache.knox.gateway.shell.BasicResponse;
import org.apache.knox.gateway.shell.KnoxSession;

public class Status {

    public static class Response
    extends BasicResponse {
        Response(HttpResponse response) throws IOException {
            super(response);
        }

        public boolean exists() {
            return this.getStatusCode() == 200;
        }
    }

    public static class Request
    extends AbstractRequest<Response> {
        private String file;

        Request(KnoxSession session) {
            super(session);
        }

        public Request file(String file) {
            this.file = file;
            return this;
        }

        @Override
        public Callable<Response> callable() {
            return new Callable<Response>(){

                @Override
                public Response call() throws Exception {
                    URIBuilder uri = this.uri(new String[]{"/webhdfs/v1", file});
                    this.addQueryParam(uri, "op", "GETFILESTATUS");
                    HttpGet get = new HttpGet(uri.build());
                    return new Response((HttpResponse)this.execute((HttpRequest)get));
                }
            };
        }
    }
}

