/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.trace;

import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import org.apache.knox.gateway.servlet.SynchronousServletOutputStreamAdapter;
import org.apache.knox.gateway.trace.TraceUtil;
import org.apache.log4j.Logger;

class TraceOutput
extends SynchronousServletOutputStreamAdapter {
    private static Logger log = Logger.getLogger((String)"org.apache.knox.gateway.http.response");
    private static Logger bodyLog = Logger.getLogger((String)"org.apache.knox.gateway.http.response.body");
    private ServletOutputStream delegate;
    private static final int BUFFER_LIMIT = 1024;
    private StringBuilder buffer = new StringBuilder(1024);

    TraceOutput(ServletOutputStream delegate) {
        this.delegate = delegate;
    }

    public synchronized void write(int b) throws IOException {
        if (b >= 0) {
            this.buffer.append((char)b);
            if (this.buffer.length() == 1024) {
                this.traceBody();
            }
        }
        this.delegate.write(b);
    }

    public void flush() throws IOException {
        this.traceBody();
        this.delegate.flush();
    }

    public void close() throws IOException {
        this.traceBody();
        this.delegate.close();
    }

    private synchronized void traceBody() {
        if (this.buffer.length() > 0) {
            String body = this.buffer.toString();
            this.buffer.setLength(0);
            StringBuilder sb = new StringBuilder();
            TraceUtil.appendCorrelationContext(sb);
            sb.append(String.format(Locale.ROOT, "|ResponseBody[%d]%n\t%s", body.length(), body));
            if (bodyLog.isTraceEnabled()) {
                log.trace((Object)sb.toString());
            }
        }
    }
}

