/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.security.impl;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.knox.gateway.i18n.GatewaySpiMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.security.KeystoreServiceException;
import org.apache.knox.gateway.services.security.impl.BaseKeystoreService;
import org.apache.knox.gateway.services.security.impl.X509CertificateUtil;

public class CMFKeystoreService
extends BaseKeystoreService {
    private static GatewaySpiMessages LOG = (GatewaySpiMessages)MessagesFactory.get(GatewaySpiMessages.class);
    private static final String TEST_CERT_DN = "CN=hadoop,OU=Test,O=Hadoop,L=Test,ST=Test,C=US";
    private static final String CREDENTIALS_SUFFIX = "-credentials.jceks";
    private String serviceName = null;

    public CMFKeystoreService(String keystoreDir, String serviceName) throws ServiceLifecycleException {
        this.serviceName = serviceName;
        this.keyStoreDir = keystoreDir + File.separator;
        File ksd = new File(this.keyStoreDir);
        if (!ksd.exists() && !ksd.mkdirs()) {
            throw new ServiceLifecycleException("Cannot create the keystore directory");
        }
    }

    public void createKeystore() throws KeystoreServiceException {
        String filename = this.keyStoreDir + this.serviceName + ".jks";
        this.createKeystore(filename, "JKS");
    }

    public KeyStore getKeystore() throws KeystoreServiceException {
        File keyStoreFile = new File(this.keyStoreDir + this.serviceName);
        return this.getKeystore(keyStoreFile, "JKS");
    }

    public void addSelfSignedCert(String alias, char[] passphrase) throws KeystoreServiceException {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(1024);
            KeyPair KPair = keyPairGenerator.generateKeyPair();
            X509Certificate cert = X509CertificateUtil.generateCertificate(TEST_CERT_DN, KPair, 365, "SHA1withRSA");
            KeyStore privateKS = this.getKeystore();
            if (privateKS == null) {
                throw new IOException("Unable to open gateway keystore.");
            }
            privateKS.setKeyEntry(alias, KPair.getPrivate(), passphrase, new Certificate[]{cert});
            this.writeKeystoreToFile(privateKS, new File(this.keyStoreDir + this.serviceName));
        }
        catch (IOException | GeneralSecurityException e) {
            LOG.failedToAddSeflSignedCertForGateway(alias, e);
        }
    }

    public void createCredentialStore() throws KeystoreServiceException {
        String filename = this.keyStoreDir + this.serviceName + CREDENTIALS_SUFFIX;
        this.createKeystore(filename, "JCEKS");
    }

    public boolean isCredentialStoreAvailable() throws KeystoreServiceException {
        File keyStoreFile = new File(this.keyStoreDir + this.serviceName + CREDENTIALS_SUFFIX);
        try {
            return this.isKeystoreAvailable(keyStoreFile, "JCEKS");
        }
        catch (IOException | KeyStoreException e) {
            throw new KeystoreServiceException(e);
        }
    }

    public boolean isKeystoreAvailable() throws KeystoreServiceException {
        File keyStoreFile = new File(this.keyStoreDir + this.serviceName + ".jks");
        try {
            return this.isKeystoreAvailable(keyStoreFile, "JKS");
        }
        catch (IOException | KeyStoreException e) {
            throw new KeystoreServiceException(e);
        }
    }

    public Key getKey(String alias, char[] passphrase) throws KeystoreServiceException {
        Key key = null;
        KeyStore ks = this.getKeystore();
        if (ks != null) {
            try {
                key = ks.getKey(alias, passphrase);
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                LOG.failedToGetKey(alias, e);
            }
        }
        return key;
    }

    public KeyStore getCredentialStore() throws KeystoreServiceException {
        File keyStoreFile = new File(this.keyStoreDir + this.serviceName + CREDENTIALS_SUFFIX);
        return this.getKeystore(keyStoreFile, "JCEKS");
    }

    public void addCredential(String alias, String value) throws KeystoreServiceException {
        KeyStore ks = this.getCredentialStore();
        this.addCredential(alias, value, ks);
        File keyStoreFile = new File(this.keyStoreDir + this.serviceName + CREDENTIALS_SUFFIX);
        try {
            this.writeKeystoreToFile(ks, keyStoreFile);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            LOG.failedToAddCredential(e);
        }
    }

    public char[] getCredential(String alias) throws KeystoreServiceException {
        char[] credential = null;
        KeyStore ks = this.getCredentialStore();
        credential = this.getCredential(alias, credential, ks);
        return credential;
    }
}

