/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.ha.provider.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.knox.gateway.ha.provider.HaDescriptor;
import org.apache.knox.gateway.ha.provider.HaServiceConfig;
import org.apache.knox.gateway.ha.provider.impl.DefaultHaDescriptor;
import org.apache.knox.gateway.ha.provider.impl.DefaultHaServiceConfig;
import org.apache.knox.gateway.ha.provider.impl.HaServiceConfigConstants;

public abstract class HaDescriptorFactory
implements HaServiceConfigConstants {
    public static HaDescriptor createDescriptor() {
        return new DefaultHaDescriptor();
    }

    public static HaServiceConfig createServiceConfig(String serviceName, String config) {
        Map<String, String> configMap = HaDescriptorFactory.parseHaConfiguration(config);
        String enabledValue = configMap.get("enabled");
        String maxFailoverAttempts = configMap.get("maxFailoverAttempts");
        String failoverSleep = configMap.get("failoverSleep");
        String maxRetryAttempts = configMap.get("maxRetryAttempts");
        String retrySleep = configMap.get("retrySleep");
        String zookeeperEnsemble = configMap.get("zookeeperEnsemble");
        String zookeeperNamespace = configMap.get("zookeeperNamespace");
        return HaDescriptorFactory.createServiceConfig(serviceName, enabledValue, maxFailoverAttempts, failoverSleep, maxRetryAttempts, retrySleep, zookeeperEnsemble, zookeeperNamespace);
    }

    public static HaServiceConfig createServiceConfig(String serviceName, String enabledValue, String maxFailoverAttemptsValue, String failoverSleepValue, String maxRetryAttemptsValue, String retrySleepValue, String zookeeperEnsemble, String zookeeperNamespace) {
        boolean enabled = true;
        int maxFailoverAttempts = 3;
        int failoverSleep = 1000;
        int maxRetryAttempts = 3;
        int retrySleep = 1000;
        if (enabledValue != null && enabledValue.trim().length() > 0) {
            enabled = Boolean.parseBoolean(enabledValue);
        }
        if (maxFailoverAttemptsValue != null && maxFailoverAttemptsValue.trim().length() > 0) {
            maxFailoverAttempts = Integer.parseInt(maxFailoverAttemptsValue);
        }
        if (failoverSleepValue != null && failoverSleepValue.trim().length() > 0) {
            failoverSleep = Integer.parseInt(failoverSleepValue);
        }
        if (maxRetryAttemptsValue != null && maxRetryAttemptsValue.trim().length() > 0) {
            maxRetryAttempts = Integer.parseInt(maxRetryAttemptsValue);
        }
        if (retrySleepValue != null && retrySleepValue.trim().length() > 0) {
            retrySleep = Integer.parseInt(retrySleepValue);
        }
        DefaultHaServiceConfig serviceConfig = new DefaultHaServiceConfig(serviceName);
        serviceConfig.setEnabled(enabled);
        serviceConfig.setMaxFailoverAttempts(maxFailoverAttempts);
        serviceConfig.setFailoverSleep(failoverSleep);
        serviceConfig.setMaxRetryAttempts(maxRetryAttempts);
        serviceConfig.setRetrySleep(retrySleep);
        serviceConfig.setZookeeperEnsemble(zookeeperEnsemble);
        serviceConfig.setZookeeperNamespace(zookeeperNamespace);
        return serviceConfig;
    }

    private static Map<String, String> parseHaConfiguration(String configuration) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (configuration != null) {
            String[] pairs;
            for (String pair : pairs = configuration.split(";")) {
                String[] tokens = pair.split("=");
                if (tokens.length != 2) continue;
                parameters.put(tokens[0], tokens[1]);
            }
        }
        return parameters;
    }
}

