/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jms.command;

import java.util.List;
import org.apache.karaf.jms.JmsMessage;
import org.apache.karaf.jms.command.JmsConnectionCommandSupport;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="jms", name="browse", description="Browse a JMS queue")
@Service
public class BrowseCommand
extends JmsConnectionCommandSupport {
    @Argument(index=1, name="queue", description="The JMS queue to browse", required=true, multiValued=false)
    String queue;
    @Option(name="-s", aliases={"--selector"}, description="The selector to select the messages to browse", required=false, multiValued=false)
    String selector;
    @Option(name="-v", aliases={"--verbose"}, description="Display JMS properties", required=false, multiValued=false)
    boolean verbose = false;

    public Object execute() throws Exception {
        ShellTable table = new ShellTable();
        table.column("Message ID");
        table.column("Content").maxSize(80);
        table.column("Charset");
        table.column("Type");
        table.column("Correlation ID");
        table.column("Delivery Mode");
        table.column("Destination");
        table.column("Expiration");
        table.column("Priority");
        table.column("Redelivered");
        table.column("ReplyTo");
        table.column("Timestamp");
        if (this.verbose) {
            table.column("Properties");
        }
        List<JmsMessage> messages = this.getJmsService().browse(this.connectionFactory, this.queue, this.selector, this.username, this.password);
        for (JmsMessage message : messages) {
            if (this.verbose) {
                StringBuilder properties = new StringBuilder();
                for (String property : message.getProperties().keySet()) {
                    properties.append(property).append("=").append(message.getProperties().get(property)).append("\n");
                }
                table.addRow().addContent(new Object[]{message.getMessageId(), message.getContent(), message.getCharset(), message.getType(), message.getCorrelationID(), message.getDeliveryMode(), message.getDestination(), message.getExpiration(), message.getPriority(), message.isRedelivered(), message.getReplyTo(), message.getTimestamp(), properties.toString()});
                continue;
            }
            table.addRow().addContent(new Object[]{message.getMessageId(), message.getContent(), message.getCharset(), message.getType(), message.getCorrelationID(), message.getDeliveryMode(), message.getDestination(), message.getExpiration(), message.getPriority(), message.isRedelivered(), message.getReplyTo(), message.getTimestamp()});
        }
        table.print(System.out);
        return null;
    }
}

