/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.Identity;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.security.SecurityUtils;

public enum BuiltinIdentities implements Identity
{
    RSA("RSA", RSAPublicKey.class, RSAPrivateKey.class),
    DSA("DSA", DSAPublicKey.class, DSAPrivateKey.class),
    ECDSA("ECDSA", "EC", ECPublicKey.class, ECPrivateKey.class){

        @Override
        public boolean isSupported() {
            return SecurityUtils.isECCSupported();
        }
    }
    ,
    ED25119("ED25519", "EdDSA", (Class)SecurityUtils.getEDDSAPublicKeyType(), (Class)SecurityUtils.getEDDSAPrivateKeyType()){

        @Override
        public boolean isSupported() {
            return SecurityUtils.isEDDSACurveSupported();
        }
    };

    public static final Set<BuiltinIdentities> VALUES;
    public static final Set<String> NAMES;
    private final String name;
    private final String algorithm;
    private final Class<? extends PublicKey> pubType;
    private final Class<? extends PrivateKey> prvType;

    private BuiltinIdentities(String type, Class<? extends PublicKey> pubType, Class<? extends PrivateKey> prvType) {
        this(type, type, pubType, prvType);
    }

    private BuiltinIdentities(String name, String algorithm, Class<? extends PublicKey> pubType, Class<? extends PrivateKey> prvType) {
        this.name = name.toLowerCase();
        this.algorithm = algorithm.toUpperCase();
        this.pubType = pubType;
        this.prvType = prvType;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public final Class<? extends PublicKey> getPublicKeyType() {
        return this.pubType;
    }

    @Override
    public final Class<? extends PrivateKey> getPrivateKeyType() {
        return this.prvType;
    }

    public static BuiltinIdentities fromName(String name) {
        return NamedResource.findByName(name, String.CASE_INSENSITIVE_ORDER, VALUES);
    }

    public static BuiltinIdentities fromAlgorithm(String algorithm) {
        if (GenericUtils.isEmpty(algorithm)) {
            return null;
        }
        for (BuiltinIdentities id : VALUES) {
            if (!algorithm.equalsIgnoreCase(id.getAlgorithm())) continue;
            return id;
        }
        return null;
    }

    public static BuiltinIdentities fromKeyPair(KeyPair kp) {
        BuiltinIdentities i2;
        if (kp == null) {
            return null;
        }
        BuiltinIdentities i1 = BuiltinIdentities.fromKey(kp.getPublic());
        if (Objects.equals(i1, i2 = BuiltinIdentities.fromKey(kp.getPrivate()))) {
            return i1;
        }
        return null;
    }

    public static BuiltinIdentities fromKey(Key key) {
        return BuiltinIdentities.fromKeyType(key == null ? null : key.getClass());
    }

    public static BuiltinIdentities fromKeyType(Class<?> clazz) {
        if (clazz == null || !Key.class.isAssignableFrom(clazz)) {
            return null;
        }
        for (BuiltinIdentities id : VALUES) {
            Class<? extends PublicKey> pubType = id.getPublicKeyType();
            Class<? extends PrivateKey> prvType = id.getPrivateKeyType();
            if (prvType == null || pubType == null || prvType == PrivateKey.class || pubType == PublicKey.class || !pubType.isAssignableFrom(clazz) && !prvType.isAssignableFrom(clazz)) continue;
            return id;
        }
        return null;
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(BuiltinIdentities.class));
        NAMES = Collections.unmodifiableSet(GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, NamedResource.getNameList(VALUES)));
    }

    public static final class Constants {
        public static final String RSA = "RSA";
        public static final String DSA = "DSA";
        public static final String ECDSA = "ECDSA";
        public static final String ED25519 = "ED25519";
    }
}

