/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.dispatch;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.http.base.internal.handler.FilterHandler;
import org.apache.felix.http.base.internal.handler.ServletHandler;

public class InvocationChain
implements FilterChain {
    private final ServletHandler servletHandler;
    private final FilterHandler[] filterHandlers;
    private int index = -1;

    public InvocationChain(@Nonnull ServletHandler servletHandler, @Nonnull FilterHandler[] filterHandlers) {
        this.filterHandlers = filterHandlers;
        this.servletHandler = servletHandler;
    }

    public final void doFilter(@Nonnull ServletRequest req, @Nonnull ServletResponse res) throws IOException, ServletException {
        if (this.index == -1) {
            HttpServletRequest hReq = (HttpServletRequest)req;
            HttpServletResponse hRes = (HttpServletResponse)res;
            if (!this.servletHandler.getContext().handleSecurity(hReq, hRes)) {
                if (!(res.isCommitted() || hRes.getStatus() != 200 && hRes.getStatus() != 0)) {
                    hRes.sendError(403);
                }
                return;
            }
        }
        ++this.index;
        if (this.index < this.filterHandlers.length) {
            this.filterHandlers[this.index].handle(req, res, this);
        } else {
            this.servletHandler.handle(req, res);
        }
    }
}

