/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.op;

import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.op.Op0;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.util.NodeIsomorphismMap;

public class OpBGP
extends Op0 {
    private BasicPattern pattern;

    public static boolean isBGP(Op op) {
        return op instanceof OpBGP;
    }

    public OpBGP() {
        this(new BasicPattern());
    }

    public OpBGP(BasicPattern pattern) {
        this.pattern = pattern;
    }

    public BasicPattern getPattern() {
        return this.pattern;
    }

    @Override
    public String getName() {
        return "bgp";
    }

    @Override
    public Op apply(Transform transform) {
        return transform.transform(this);
    }

    @Override
    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    @Override
    public Op0 copy() {
        return new OpBGP(this.pattern);
    }

    @Override
    public int hashCode() {
        int calcHashCode = 177;
        return calcHashCode ^= this.pattern.hashCode();
    }

    @Override
    public boolean equalTo(Op op2, NodeIsomorphismMap labelMap) {
        if (!(op2 instanceof OpBGP)) {
            return false;
        }
        OpBGP bgp2 = (OpBGP)op2;
        return this.pattern.equiv(bgp2.pattern, labelMap);
    }
}

