/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.core.Username;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;

public class DeletedMessage {
    private final MessageId messageId;
    private final List<MailboxId> originMailboxes;
    private final Username owner;
    private final ZonedDateTime deliveryDate;
    private final ZonedDateTime deletionDate;
    private final MaybeSender sender;
    private final List<MailAddress> recipients;
    private final Optional<String> subject;
    private final boolean hasAttachment;
    private final long size;

    public static Builder.Steps.RequireMetadata<Builder.FinalStage> builder() {
        return messageId -> originMailboxes -> user -> deliveryDate -> deletionDate -> sender -> recipients -> hasAttachment -> size -> new Builder.FinalStage(messageId, originMailboxes, user, deliveryDate, deletionDate, sender, (List<MailAddress>)ImmutableList.copyOf((Collection)recipients), hasAttachment, size);
    }

    public DeletedMessage(MessageId messageId, List<MailboxId> originMailboxes, Username owner, ZonedDateTime deliveryDate, ZonedDateTime deletionDate, MaybeSender sender, List<MailAddress> recipients, Optional<String> subject, boolean hasAttachment, long size) {
        Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (Object)"'size' is required to be a non negative number");
        this.messageId = messageId;
        this.originMailboxes = originMailboxes;
        this.owner = owner;
        this.deliveryDate = deliveryDate;
        this.deletionDate = deletionDate;
        this.sender = sender;
        this.recipients = recipients;
        this.subject = subject;
        this.hasAttachment = hasAttachment;
        this.size = size;
    }

    public MessageId getMessageId() {
        return this.messageId;
    }

    public List<MailboxId> getOriginMailboxes() {
        return this.originMailboxes;
    }

    public Username getOwner() {
        return this.owner;
    }

    public ZonedDateTime getDeliveryDate() {
        return this.deliveryDate;
    }

    public ZonedDateTime getDeletionDate() {
        return this.deletionDate;
    }

    public MaybeSender getSender() {
        return this.sender;
    }

    public List<MailAddress> getRecipients() {
        return this.recipients;
    }

    public Optional<String> getSubject() {
        return this.subject;
    }

    public boolean hasAttachment() {
        return this.hasAttachment;
    }

    public long getSize() {
        return this.size;
    }

    public final boolean equals(Object o) {
        if (o instanceof DeletedMessage) {
            DeletedMessage that = (DeletedMessage)o;
            return Objects.equals(this.hasAttachment, that.hasAttachment) && Objects.equals(this.messageId, that.messageId) && Objects.equals(this.originMailboxes, that.originMailboxes) && Objects.equals(this.owner, that.owner) && Objects.equals(this.deliveryDate, that.deliveryDate) && Objects.equals(this.deletionDate, that.deletionDate) && Objects.equals(this.sender, that.sender) && Objects.equals(this.recipients, that.recipients) && Objects.equals(this.subject, that.subject) && Objects.equals(this.size, that.size);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.messageId, this.originMailboxes, this.owner, this.deliveryDate, this.deletionDate, this.sender, this.recipients, this.subject, this.hasAttachment, this.size);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("owner", (Object)this.owner).add("messageId", (Object)this.messageId).add("originMailboxes", this.originMailboxes).add("owner", (Object)this.owner).add("deliveryDate", (Object)this.deliveryDate).add("deletionDate", (Object)this.deletionDate).add("sender", (Object)this.sender).add("recipients", this.recipients).add("subject", this.subject).add("size", this.size).toString();
    }

    public static class Builder {

        public static class FinalStage {
            private final MessageId messageId;
            private final List<MailboxId> originMailboxes;
            private final Username owner;
            private final ZonedDateTime deliveryDate;
            private final ZonedDateTime deletionDate;
            private final MaybeSender sender;
            private final List<MailAddress> recipients;
            private final boolean hasAttachment;
            private final long size;
            private Optional<String> subject;

            FinalStage(MessageId messageId, List<MailboxId> originMailboxes, Username owner, ZonedDateTime deliveryDate, ZonedDateTime deletionDate, MaybeSender sender, List<MailAddress> recipients, boolean hasAttachment, long size) {
                this.messageId = messageId;
                this.originMailboxes = originMailboxes;
                this.owner = owner;
                this.deliveryDate = deliveryDate;
                this.deletionDate = deletionDate;
                this.sender = sender;
                this.recipients = recipients;
                this.hasAttachment = hasAttachment;
                this.size = size;
                this.subject = Optional.empty();
            }

            public FinalStage subject(String subject) {
                this.subject = Optional.of(subject);
                return this;
            }

            public FinalStage subject(Optional<String> subject) {
                this.subject = subject;
                return this;
            }

            public DeletedMessage build() {
                return new DeletedMessage(this.messageId, this.originMailboxes, this.owner, this.deliveryDate, this.deletionDate, this.sender, this.recipients, this.subject, this.hasAttachment, this.size);
            }
        }

        static interface Steps {

            public static interface RequireMetadata<T>
            extends RequireMailboxContext<RequireDates<RequireEnvelope<RequireHasAttachment<RequireSize<T>>>>> {
            }

            public static interface RequireDates<T>
            extends RequireDeliveryDate<RequireDeletionDate<T>> {
            }

            public static interface RequireEnvelope<T>
            extends RequireSender<RequireRecipients<T>> {
            }

            public static interface RequireMailboxContext<T>
            extends RequireMessageId<RequireOriginMailboxes<RequireUser<T>>> {
            }
        }

        @FunctionalInterface
        public static interface RequireSize<T> {
            public T size(long var1);
        }

        @FunctionalInterface
        public static interface RequireHasAttachment<T> {
            public T hasAttachment(boolean var1);

            default public T hasAttachment() {
                return this.hasAttachment(true);
            }

            default public T hasNoAttachments() {
                return this.hasAttachment(false);
            }
        }

        @FunctionalInterface
        public static interface RequireRecipients<T> {
            public T recipients(Collection<MailAddress> var1);

            default public T recipients(MailAddress ... recipients) {
                return this.recipients((Collection<MailAddress>)ImmutableList.copyOf((Object[])recipients));
            }
        }

        @FunctionalInterface
        public static interface RequireSender<T> {
            public T sender(MaybeSender var1);
        }

        @FunctionalInterface
        public static interface RequireDeletionDate<T> {
            public T deletionDate(ZonedDateTime var1);
        }

        @FunctionalInterface
        public static interface RequireDeliveryDate<T> {
            public T deliveryDate(ZonedDateTime var1);
        }

        @FunctionalInterface
        public static interface RequireOriginMailboxes<T> {
            public T originMailboxes(List<MailboxId> var1);

            default public T originMailboxes(MailboxId ... mailboxIds) {
                return this.originMailboxes((List<MailboxId>)ImmutableList.copyOf((Object[])mailboxIds));
            }
        }

        @FunctionalInterface
        public static interface RequireUser<T> {
            public T user(Username var1);
        }

        @FunctionalInterface
        public static interface RequireMessageId<T> {
            public T messageId(MessageId var1);
        }
    }
}

