/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.postgres;

import jakarta.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.user.api.DelegationStore;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.postgres.PostgresUsersDAO;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class PostgresDelegationStore
implements DelegationStore {
    private final PostgresUsersDAO postgresUsersDAO;
    private final UserExistencePredicate userExistencePredicate;

    @Inject
    public PostgresDelegationStore(PostgresUsersDAO postgresUsersDAO, UserExistencePredicate userExistencePredicate) {
        this.postgresUsersDAO = postgresUsersDAO;
        this.userExistencePredicate = userExistencePredicate;
    }

    public Publisher<Username> authorizedUsers(Username baseUser) {
        return this.postgresUsersDAO.getAuthorizedUsers(baseUser);
    }

    public Publisher<Void> clear(Username baseUser) {
        return this.postgresUsersDAO.removeAllAuthorizedUsers(baseUser);
    }

    public Publisher<Void> addAuthorizedUser(Username baseUser, Username userWithAccess) {
        return this.userExistencePredicate.exists(userWithAccess).flatMap(targetUserExists -> this.postgresUsersDAO.addAuthorizedUser(baseUser, userWithAccess, (boolean)targetUserExists));
    }

    public Publisher<Void> removeAuthorizedUser(Username baseUser, Username userWithAccess) {
        return this.postgresUsersDAO.removeAuthorizedUser(baseUser, userWithAccess);
    }

    public Publisher<Username> delegatedUsers(Username baseUser) {
        return this.postgresUsersDAO.getDelegatedToUsers(baseUser);
    }

    public Publisher<Void> removeDelegatedUser(Username baseUser, Username delegatedToUser) {
        return this.postgresUsersDAO.removeDelegatedToUser(baseUser, delegatedToUser);
    }

    public static interface UserExistencePredicate {
        public Mono<Boolean> exists(Username var1);
    }

    public static class UserExistencePredicateImplementation
    implements UserExistencePredicate {
        private final UsersRepository usersRepository;

        @Inject
        UserExistencePredicateImplementation(UsersRepository usersRepository) {
            this.usersRepository = usersRepository;
        }

        @Override
        public Mono<Boolean> exists(Username username) {
            return Mono.from((Publisher)this.usersRepository.containsReactive(username));
        }
    }
}

