/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.metrics.api.GaugeRegistry;
import org.reactivestreams.Publisher;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Schedulers;

public class ReactiveThrottler {
    private final int maxConcurrentRequests;
    private final int maxQueueSize;
    private final AtomicInteger concurrentRequests = new AtomicInteger(0);
    private final Queue<TaskHolder> queue = new ConcurrentLinkedQueue<TaskHolder>();
    private final Sinks.Many<TaskHolder> sink;

    public ReactiveThrottler(GaugeRegistry gaugeRegistry, int maxConcurrentRequests, int maxQueueSize) {
        gaugeRegistry.register("imap.request.queue.size", () -> Math.max(this.concurrentRequests.get() - maxConcurrentRequests, 0));
        this.maxConcurrentRequests = maxConcurrentRequests;
        this.maxQueueSize = maxQueueSize;
        this.sink = Sinks.many().multicast().onBackpressureBuffer();
        this.sink.asFlux().subscribeOn(Schedulers.parallel()).subscribe(taskHolder -> taskHolder.ctx.accept(() -> {
            Disposable disposable = Mono.from(taskHolder.task).doFinally(any -> this.onRequestDone()).subscribe();
            taskHolder.disposable.set(disposable);
        }));
    }

    @VisibleForTesting
    public Mono<Void> throttle(Publisher<Void> task, ImapMessage imapMessage) {
        return this.throttle(task, imapMessage, Runnable::run);
    }

    public Mono<Void> throttle(Publisher<Void> task, ImapMessage imapMessage, Consumer<Runnable> ctx) {
        if (this.maxConcurrentRequests < 0) {
            return Mono.from(task);
        }
        int requestNumber = this.concurrentRequests.incrementAndGet();
        if (requestNumber <= this.maxConcurrentRequests) {
            return Mono.from(task).doFinally(any -> this.onRequestDone());
        }
        if (requestNumber <= this.maxQueueSize + this.maxConcurrentRequests) {
            AtomicBoolean cancelled = new AtomicBoolean(false);
            Sinks.One one = Sinks.one();
            TaskHolder taskHolder = new TaskHolder((Publisher<Void>)Mono.fromCallable(cancelled::get).flatMap(cancel -> {
                if (cancel.booleanValue()) {
                    return Mono.empty();
                }
                return Mono.from((Publisher)task);
            }).then(Mono.fromRunnable(() -> one.emitEmpty(Sinks.EmitFailureHandler.FAIL_FAST))), ctx);
            this.queue.add(taskHolder);
            return one.asMono().doOnCancel(() -> {
                cancelled.set(true);
                Optional.ofNullable(taskHolder.disposable.get()).ifPresent(Disposable::dispose);
                boolean removed = this.queue.remove(taskHolder);
                if (removed) {
                    this.concurrentRequests.decrementAndGet();
                }
            });
        }
        this.concurrentRequests.decrementAndGet();
        return Mono.error((Throwable)new RejectedException(String.format("The IMAP server has reached its maximum capacity (concurrent requests: %d, queue size: %d)", this.maxConcurrentRequests, this.maxQueueSize), imapMessage));
    }

    public boolean isQueueFull() {
        return this.maxQueueSize <= this.queue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRequestDone() {
        this.concurrentRequests.getAndDecrement();
        TaskHolder throttled = this.queue.poll();
        if (throttled != null) {
            Sinks.Many<TaskHolder> many = this.sink;
            synchronized (many) {
                this.sink.emitNext((Object)throttled, Sinks.EmitFailureHandler.FAIL_FAST);
            }
        }
    }

    private static class TaskHolder {
        private final Publisher<Void> task;
        private final Consumer<Runnable> ctx;
        private final AtomicReference<Disposable> disposable = new AtomicReference();

        private TaskHolder(Publisher<Void> task, Consumer<Runnable> ctx) {
            this.task = task;
            this.ctx = ctx;
        }
    }

    public static class RejectedException
    extends RuntimeException {
        private final ImapMessage imapMessage;

        public RejectedException(String message, ImapMessage imapMessage) {
            super(message);
            this.imapMessage = imapMessage;
        }

        public ImapMessage getImapMessage() {
            return this.imapMessage;
        }
    }
}

