/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.CaseIgnoreStringMatchingRule;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.PropertyManager;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.IPAddressArgumentValueValidator;
import com.unboundid.util.ssl.SSLMessages;
import com.unboundid.util.ssl.SSLSocketVerifier;
import java.net.InetAddress;
import java.net.URI;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class HostNameSSLSocketVerifier
extends SSLSocketVerifier
implements HostnameVerifier {
    @NotNull
    public static final String PROPERTY_CHECK_CN_WHEN_SUBJECT_ALT_NAME_IS_PRESENT = HostNameSSLSocketVerifier.class.getName() + ".checkCNWhenSubjectAltNameIsPresent";
    static final boolean DEFAULT_CHECK_CN_WHEN_SUBJECT_ALT_NAME_IS_PRESENT = PropertyManager.getBoolean(PROPERTY_CHECK_CN_WHEN_SUBJECT_ALT_NAME_IS_PRESENT, true);
    private final boolean allowWildcards;
    private final boolean checkCNWhenSubjectAltNameIsPresent;

    public HostNameSSLSocketVerifier(boolean allowWildcards) {
        this(allowWildcards, DEFAULT_CHECK_CN_WHEN_SUBJECT_ALT_NAME_IS_PRESENT);
    }

    public HostNameSSLSocketVerifier(boolean allowWildcards, boolean checkCNWhenSubjectAltNameIsPresent) {
        this.allowWildcards = allowWildcards;
        this.checkCNWhenSubjectAltNameIsPresent = checkCNWhenSubjectAltNameIsPresent;
    }

    @Override
    public void verifySSLSocket(@NotNull String host, int port, @NotNull SSLSocket sslSocket) throws LDAPException {
        this.verifySSLSession(host, port, sslSocket.getSession());
    }

    private void verifySSLSession(@NotNull String host, int port, @NotNull SSLSession sslSession) throws LDAPException {
        block7: {
            try {
                if (sslSession == null) {
                    throw new LDAPException(ResultCode.CONNECT_ERROR, SSLMessages.ERR_HOST_NAME_SSL_SOCKET_VERIFIER_NO_SESSION.get(host, port));
                }
                Certificate[] peerCertificateChain = sslSession.getPeerCertificates();
                if (peerCertificateChain == null || peerCertificateChain.length == 0) {
                    throw new LDAPException(ResultCode.CONNECT_ERROR, SSLMessages.ERR_HOST_NAME_SSL_SOCKET_VERIFIER_NO_PEER_CERTS.get(host, port));
                }
                if (peerCertificateChain[0] instanceof X509Certificate) {
                    StringBuilder certInfo = new StringBuilder();
                    if (!HostNameSSLSocketVerifier.certificateIncludesHostname(host, (X509Certificate)peerCertificateChain[0], this.allowWildcards, this.checkCNWhenSubjectAltNameIsPresent, certInfo)) {
                        throw new LDAPException(ResultCode.CONNECT_ERROR, SSLMessages.ERR_HOST_NAME_SSL_SOCKET_VERIFIER_HOSTNAME_NOT_FOUND.get(host, certInfo.toString()));
                    }
                    break block7;
                }
                throw new LDAPException(ResultCode.CONNECT_ERROR, SSLMessages.ERR_HOST_NAME_SSL_SOCKET_VERIFIER_PEER_NOT_X509.get(host, port, peerCertificateChain[0].getType()));
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                throw le;
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.CONNECT_ERROR, SSLMessages.ERR_HOST_NAME_SSL_SOCKET_VERIFIER_EXCEPTION.get(host, port, StaticUtils.getExceptionMessage(e)), e);
            }
        }
    }

    static boolean certificateIncludesHostname(@NotNull String host, @NotNull X509Certificate certificate, boolean allowWildcards, boolean checkCNWhenSubjectAltNameIsPresent, @NotNull StringBuilder certInfo) {
        InetAddress hostInetAddress = null;
        if (IPAddressArgumentValueValidator.isValidNumericIPAddress(host)) {
            try {
                hostInetAddress = LDAPConnectionOptions.DEFAULT_NAME_RESOLVER.getByName(host);
                if (hostInetAddress.isLoopbackAddress()) {
                    return true;
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        String subjectDNString = certificate.getSubjectX500Principal().getName("RFC2253");
        certInfo.append("subject='");
        certInfo.append(subjectDNString);
        certInfo.append('\'');
        boolean hasAuthoritativeSubjectAlternativeName = false;
        try {
            Collection<List<?>> subjectAltNames = certificate.getSubjectAlternativeNames();
            if (subjectAltNames != null) {
                for (List<?> l : subjectAltNames) {
                    Integer type = (Integer)l.get(0);
                    switch (type) {
                        case 2: {
                            String dnsName = (String)l.get(1);
                            certInfo.append(" dnsName='");
                            certInfo.append(dnsName);
                            certInfo.append('\'');
                            if (HostNameSSLSocketVerifier.hostnameMatches(host, dnsName, allowWildcards)) {
                                return true;
                            }
                            hasAuthoritativeSubjectAlternativeName = true;
                            break;
                        }
                        case 6: {
                            String uriString = (String)l.get(1);
                            certInfo.append(" uniformResourceIdentifier='");
                            certInfo.append(uriString);
                            certInfo.append('\'');
                            String uriHost = HostNameSSLSocketVerifier.getHostFromURI(uriString);
                            if (uriHost != null && (IPAddressArgumentValueValidator.isValidNumericIPAddress(uriHost) ? hostInetAddress != null && HostNameSSLSocketVerifier.ipAddressMatches(hostInetAddress, uriHost) : HostNameSSLSocketVerifier.hostnameMatches(host, uriHost, allowWildcards))) {
                                return true;
                            }
                            hasAuthoritativeSubjectAlternativeName = true;
                            break;
                        }
                        case 7: {
                            String ipAddressString = (String)l.get(1);
                            certInfo.append(" ipAddress='");
                            certInfo.append(ipAddressString);
                            certInfo.append('\'');
                            if (hostInetAddress != null && HostNameSSLSocketVerifier.ipAddressMatches(hostInetAddress, ipAddressString)) {
                                return true;
                            }
                            hasAuthoritativeSubjectAlternativeName = true;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        if (hasAuthoritativeSubjectAlternativeName && !checkCNWhenSubjectAltNameIsPresent) {
            return false;
        }
        try {
            DN subjectDN = new DN(subjectDNString);
            for (RDN rdn : subjectDN.getRDNs()) {
                String[] names = rdn.getAttributeNames();
                String[] values = rdn.getAttributeValues();
                for (int i = 0; i < names.length; ++i) {
                    String cnValue;
                    String lowerName = StaticUtils.toLowerCase(names[i]);
                    if (!lowerName.equals("cn") && !lowerName.equals("commonname") && !lowerName.equals("2.5.4.3") || !(IPAddressArgumentValueValidator.isValidNumericIPAddress(cnValue = values[i]) ? hostInetAddress != null && HostNameSSLSocketVerifier.ipAddressMatches(hostInetAddress, cnValue) : HostNameSSLSocketVerifier.hostnameMatches(host, cnValue, allowWildcards))) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        return false;
    }

    private static boolean hostnameMatches(@NotNull String clientHostname, @NotNull String certificateHostname, boolean allowWildcards) {
        Filter filter;
        if (!certificateHostname.contains("*")) {
            return clientHostname.equalsIgnoreCase(certificateHostname);
        }
        if (!allowWildcards) {
            return false;
        }
        ObjectPair<String, String> clientFirstComponentAndRemainder = HostNameSSLSocketVerifier.getFirstComponentAndRemainder(clientHostname);
        ObjectPair<String, String> certificateFirstComponentAndRemainder = HostNameSSLSocketVerifier.getFirstComponentAndRemainder(certificateHostname);
        if (!clientFirstComponentAndRemainder.getSecond().equalsIgnoreCase(certificateFirstComponentAndRemainder.getSecond())) {
            return false;
        }
        String certificateFirstComponent = certificateFirstComponentAndRemainder.getFirst();
        if (certificateFirstComponent.equals("*")) {
            return true;
        }
        try {
            filter = Filter.create("(hostname=" + certificateFirstComponent + ')');
            if (filter.getFilterType() != -92) {
                return false;
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            return false;
        }
        return CaseIgnoreStringMatchingRule.getInstance().matchesSubstring(new ASN1OctetString(clientFirstComponentAndRemainder.getFirst()), filter.getRawSubInitialValue(), filter.getRawSubAnyValues(), filter.getRawSubFinalValue());
    }

    @NotNull
    private static ObjectPair<String, String> getFirstComponentAndRemainder(@NotNull String address) {
        int periodPos = address.indexOf(46);
        if (periodPos < 0) {
            return new ObjectPair<String, String>(address, "");
        }
        return new ObjectPair<String, String>(address.substring(0, periodPos), address.substring(periodPos));
    }

    private static boolean ipAddressMatches(@NotNull InetAddress clientIPAddress, @NotNull String certificateIPAddressString) {
        InetAddress certificateIPAddress;
        try {
            certificateIPAddress = LDAPConnectionOptions.DEFAULT_NAME_RESOLVER.getByName(certificateIPAddressString);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return false;
        }
        return clientIPAddress.equals(certificateIPAddress);
    }

    @Nullable
    private static String getHostFromURI(@NotNull String uriString) {
        int colonPos;
        int slashPos;
        URI uri;
        try {
            uri = new URI(uriString);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
        String uriHost = uri.getHost();
        if (uriHost != null) {
            return uriHost;
        }
        if (!uriString.contains("*")) {
            return null;
        }
        String scheme = uri.getScheme();
        if (scheme == null || scheme.isEmpty() || !uriString.toLowerCase().startsWith(scheme)) {
            return null;
        }
        String paredDownURI = uriString.substring(scheme.length());
        if (paredDownURI.startsWith("://")) {
            paredDownURI = paredDownURI.substring(3);
        }
        if ((slashPos = paredDownURI.indexOf(47)) >= 0) {
            paredDownURI = paredDownURI.substring(0, slashPos);
        }
        if ((colonPos = paredDownURI.indexOf(58)) >= 0) {
            paredDownURI = paredDownURI.substring(0, colonPos);
        }
        if (!paredDownURI.isEmpty()) {
            return paredDownURI;
        }
        return null;
    }

    @Override
    public boolean verify(@NotNull String hostname, @NotNull SSLSession session) {
        try {
            this.verifySSLSession(hostname, session.getPeerPort(), session);
            return true;
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            return false;
        }
    }
}

