/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.json;

import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONAssuredReplicationServerResult;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONFormattedAccessLogFields;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONRequestAccessLogMessage;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
final class JSONAssuranceCompletedAccessLogMessageHelper
implements Serializable {
    private static final long serialVersionUID = 8085793278405434256L;
    @Nullable
    private final Boolean localAssuranceSatisfied;
    @Nullable
    private final Boolean remoteAssuranceSatisfied;
    @NotNull
    private final List<JSONAssuredReplicationServerResult> serverResults;

    JSONAssuranceCompletedAccessLogMessageHelper(@NotNull JSONRequestAccessLogMessage logMessage) {
        this.localAssuranceSatisfied = logMessage.getBooleanNoThrow(JSONFormattedAccessLogFields.LOCAL_ASSURANCE_SATISFIED);
        this.remoteAssuranceSatisfied = logMessage.getBooleanNoThrow(JSONFormattedAccessLogFields.REMOTE_ASSURANCE_SATISFIED);
        List<JSONValue> serverResultValues = logMessage.getJSONObject().getFieldAsArray(JSONFormattedAccessLogFields.SERVER_ASSURANCE_RESULTS.getFieldName());
        if (serverResultValues == null) {
            this.serverResults = Collections.emptyList();
        } else {
            ArrayList<JSONAssuredReplicationServerResult> resultsList = new ArrayList<JSONAssuredReplicationServerResult>(serverResultValues.size());
            for (JSONValue v : serverResultValues) {
                if (!(v instanceof JSONObject)) continue;
                resultsList.add(new JSONAssuredReplicationServerResult((JSONObject)v));
            }
            this.serverResults = Collections.unmodifiableList(resultsList);
        }
    }

    @Nullable
    Boolean getLocalAssuranceSatisfied() {
        return this.localAssuranceSatisfied;
    }

    @Nullable
    Boolean getRemoteAssuranceSatisfied() {
        return this.remoteAssuranceSatisfied;
    }

    @NotNull
    List<JSONAssuredReplicationServerResult> getServerResults() {
        return this.serverResults;
    }
}

