/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ObjectTrio;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GenerateAccessTokenResponseControl
extends Control
implements DecodeableControl {
    @NotNull
    public static final String GENERATE_ACCESS_TOKEN_RESPONSE_OID = "1.3.6.1.4.1.30221.2.5.68";
    @NotNull
    private static final String JSON_FIELD_ACCESS_TOKEN = "token";
    @NotNull
    private static final String JSON_FIELD_ERROR_MESSAGE = "error-message";
    @NotNull
    private static final String JSON_FIELD_EXPIRATION_TIME = "expiration-time";
    private static final long serialVersionUID = -6071943602038789356L;
    @Nullable
    private final Long expirationTime;
    @Nullable
    private final String accesToken;
    @Nullable
    private final String errorMessage;

    GenerateAccessTokenResponseControl() {
        this.expirationTime = null;
        this.accesToken = null;
        this.errorMessage = null;
    }

    public GenerateAccessTokenResponseControl(@Nullable String accessToken, @Nullable Date expirationTime, @Nullable String errorMessage) {
        super(GENERATE_ACCESS_TOKEN_RESPONSE_OID, false, new ASN1OctetString(GenerateAccessTokenResponseControl.encodeValueObject(accessToken, expirationTime, errorMessage).toString()));
        this.accesToken = accessToken;
        this.errorMessage = errorMessage;
        this.expirationTime = expirationTime == null ? null : Long.valueOf(expirationTime.getTime());
    }

    public GenerateAccessTokenResponseControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GENERATE_ACCESS_TOKEN_RESPONSE_NO_VALUE.get());
        }
        try {
            JSONObject valueObject = new JSONObject(value.stringValue());
            ObjectTrio<String, Date, String> valueElements = GenerateAccessTokenResponseControl.decodeJSONObject(valueObject);
            this.accesToken = valueElements.getFirst();
            this.errorMessage = valueElements.getThird();
            Date expirationTimeDate = valueElements.getSecond();
            this.expirationTime = expirationTimeDate == null ? null : Long.valueOf(expirationTimeDate.getTime());
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GENERATE_ACCESS_TOKEN_RESPONSE_CANNOT_DECODE_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    private static ObjectTrio<String, Date, String> decodeJSONObject(@NotNull JSONObject valueObject) throws LDAPException {
        Date expirationTime;
        String accessToken = valueObject.getFieldAsString(JSON_FIELD_ACCESS_TOKEN);
        String errorMessage = valueObject.getFieldAsString(JSON_FIELD_ERROR_MESSAGE);
        String expirationTimeStr = valueObject.getFieldAsString(JSON_FIELD_EXPIRATION_TIME);
        if (expirationTimeStr == null) {
            expirationTime = null;
        } else {
            try {
                expirationTime = StaticUtils.decodeRFC3339Time(expirationTimeStr);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GENERATE_ACCESS_TOKEN_RESPONSE_INVALID_TIMESTAMP.get(valueObject.toSingleLineString(), JSON_FIELD_EXPIRATION_TIME));
            }
        }
        return new ObjectTrio<String, Date, String>(accessToken, expirationTime, errorMessage);
    }

    @Override
    @NotNull
    public GenerateAccessTokenResponseControl decodeControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        return new GenerateAccessTokenResponseControl(oid, isCritical, value);
    }

    @Nullable
    public static GenerateAccessTokenResponseControl get(@NotNull BindResult result) throws LDAPException {
        Control c = result.getResponseControl(GENERATE_ACCESS_TOKEN_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof GenerateAccessTokenResponseControl) {
            return (GenerateAccessTokenResponseControl)c;
        }
        return new GenerateAccessTokenResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    @NotNull
    private static JSONObject encodeValueObject(@Nullable String accessToken, @Nullable Date expirationTime, @Nullable String errorMessage) {
        return GenerateAccessTokenResponseControl.encodeValueObject(accessToken, expirationTime == null ? null : Long.valueOf(expirationTime.getTime()), errorMessage);
    }

    @NotNull
    private static JSONObject encodeValueObject(@Nullable String accessToken, @Nullable Long expirationTime, @Nullable String errorMessage) {
        LinkedHashMap<String, JSONValue> fields = new LinkedHashMap<String, JSONValue>(StaticUtils.computeMapCapacity(3));
        if (accessToken != null) {
            fields.put(JSON_FIELD_ACCESS_TOKEN, new JSONString(accessToken));
        }
        if (expirationTime != null) {
            fields.put(JSON_FIELD_EXPIRATION_TIME, new JSONString(StaticUtils.encodeRFC3339Time(expirationTime)));
        }
        if (errorMessage != null) {
            fields.put(JSON_FIELD_ERROR_MESSAGE, new JSONString(errorMessage));
        }
        return new JSONObject(fields);
    }

    @Nullable
    public String getAccessToken() {
        return this.accesToken;
    }

    @Nullable
    public Date getExpirationTime() {
        if (this.expirationTime == null) {
            return null;
        }
        return new Date(this.expirationTime);
    }

    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_GENERATE_ACCESS_TOKEN_RESPONSE.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        return new JSONObject(new JSONField("oid", GENERATE_ACCESS_TOKEN_RESPONSE_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_GENERATE_ACCESS_TOKEN_RESPONSE.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", GenerateAccessTokenResponseControl.encodeValueObject(this.accesToken, this.expirationTime, this.errorMessage)));
    }

    @NotNull
    public static GenerateAccessTokenResponseControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new GenerateAccessTokenResponseControl(jsonControl.getOID(), jsonControl.getCriticality(), rawValue);
        }
        JSONObject valueObject = jsonControl.getValueObject();
        ObjectTrio<String, Date, String> valueElements = GenerateAccessTokenResponseControl.decodeJSONObject(valueObject);
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_ACCESS_TOKEN, JSON_FIELD_EXPIRATION_TIME, JSON_FIELD_ERROR_MESSAGE)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GENERATE_TOKEN_RESPONSE_JSON_CONTROL_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new GenerateAccessTokenResponseControl(valueElements.getFirst(), valueElements.getSecond(), valueElements.getThird());
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("GenerateAccessTokenResponseControl(hasAccessToken=");
        buffer.append(this.accesToken != null);
        if (this.expirationTime != null) {
            buffer.append(", expirationTime='");
            buffer.append(StaticUtils.encodeRFC3339Time(this.expirationTime));
            buffer.append('\'');
        }
        if (this.errorMessage != null) {
            buffer.append(", errorMessage='");
            buffer.append(this.errorMessage);
            buffer.append('\'');
        }
        buffer.append(')');
    }
}

