/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.SASLBindRequest;
import com.unboundid.ldap.sdk.ToCodeArgHelper;
import com.unboundid.ldap.sdk.ToCodeHelper;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GenericSASLBindRequest
extends SASLBindRequest {
    private static final long serialVersionUID = 7740968332104559230L;
    @Nullable
    private final ASN1OctetString credentials;
    @Nullable
    private final String bindDN;
    @NotNull
    private final String mechanism;

    public GenericSASLBindRequest(@Nullable String bindDN, @NotNull String mechanism, @Nullable ASN1OctetString credentials, Control ... controls) {
        super(controls);
        Validator.ensureNotNull(mechanism);
        this.bindDN = bindDN;
        this.mechanism = mechanism;
        this.credentials = credentials;
    }

    @Nullable
    public String getBindDN() {
        return this.bindDN;
    }

    @Override
    @NotNull
    public String getSASLMechanismName() {
        return this.mechanism;
    }

    @Nullable
    public ASN1OctetString getCredentials() {
        return this.credentials;
    }

    @Override
    @NotNull
    protected BindResult process(@NotNull LDAPConnection connection, int depth) throws LDAPException {
        this.setReferralDepth(depth);
        return this.sendBindRequest(connection, this.bindDN, this.credentials, this.getControls(), this.getResponseTimeoutMillis(connection));
    }

    @Override
    @NotNull
    public GenericSASLBindRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    @NotNull
    public GenericSASLBindRequest duplicate(@Nullable Control[] controls) {
        GenericSASLBindRequest bindRequest = new GenericSASLBindRequest(this.bindDN, this.mechanism, this.credentials, controls);
        bindRequest.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        bindRequest.setIntermediateResponseListener(this.getIntermediateResponseListener());
        bindRequest.setReferralDepth(this.getReferralDepth());
        bindRequest.setReferralConnector(this.getReferralConnectorInternal());
        return bindRequest;
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        Control[] controls;
        buffer.append("GenericSASLBindRequest(mechanism='");
        buffer.append(this.mechanism);
        buffer.append('\'');
        if (this.bindDN != null) {
            buffer.append(", bindDN='");
            buffer.append(this.bindDN);
            buffer.append('\'');
        }
        if (this.credentials != null) {
            buffer.append(", credentials=byte[");
            buffer.append(this.credentials.getValueLength());
            buffer.append(']');
        }
        if ((controls = this.getControls()).length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }

    @Override
    public void toCode(@NotNull List<String> lineList, @NotNull String requestID, int indentSpaces, boolean includeProcessing) {
        ArrayList<ToCodeArgHelper> constructorArgs = new ArrayList<ToCodeArgHelper>(4);
        constructorArgs.add(ToCodeArgHelper.createString(this.bindDN, "Bind DN"));
        constructorArgs.add(ToCodeArgHelper.createString(this.mechanism, "SASL Mechanism Name"));
        constructorArgs.add(ToCodeArgHelper.createByteArray("---redacted-SASL-credentials".getBytes(StandardCharsets.UTF_8), true, "SASL Credentials"));
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            constructorArgs.add(ToCodeArgHelper.createControlArray(controls, "Bind Controls"));
        }
        ToCodeHelper.generateMethodCall(lineList, indentSpaces, "GenericSASLBindRequest", requestID + "Request", "new GenericSASLBindRequest", constructorArgs);
        if (includeProcessing) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < indentSpaces; ++i) {
                buffer.append(' ');
            }
            String indent = buffer.toString();
            lineList.add("");
            lineList.add(indent + '{');
            lineList.add(indent + "  BindResult " + requestID + "Result = connection.bind(" + requestID + "Request);");
            lineList.add(indent + "  // The bind was processed successfully.");
            lineList.add(indent + '}');
            lineList.add(indent + "catch (SASLBindInProgressException e)");
            lineList.add(indent + '{');
            lineList.add(indent + "  // The SASL bind requires multiple stages.  Continue it here.");
            lineList.add(indent + "  // Do not attempt to use the connection for any other purpose until bind processing has completed.");
            lineList.add(indent + '}');
            lineList.add(indent + "catch (LDAPException e)");
            lineList.add(indent + '{');
            lineList.add(indent + "  // The bind failed.  Maybe the following will help explain why.");
            lineList.add(indent + "  // Note that the connection is now likely in an unauthenticated state.");
            lineList.add(indent + "  ResultCode resultCode = e.getResultCode();");
            lineList.add(indent + "  String message = e.getMessage();");
            lineList.add(indent + "  String matchedDN = e.getMatchedDN();");
            lineList.add(indent + "  String[] referralURLs = e.getReferralURLs();");
            lineList.add(indent + "  Control[] responseControls = e.getResponseControls();");
            lineList.add(indent + '}');
        }
    }
}

