/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail;

import org.apache.james.core.Username;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.UidValidity;
import org.apache.james.mailbox.model.search.MailboxNameExpression;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.mailbox.model.search.Wildcard;
import org.apache.james.mailbox.store.transaction.Mapper;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface MailboxMapper
extends Mapper {
    public Mono<Mailbox> create(MailboxPath var1, UidValidity var2);

    public Mono<MailboxId> rename(Mailbox var1);

    public Mono<Void> delete(Mailbox var1);

    public Mono<Mailbox> findMailboxByPath(MailboxPath var1);

    default public Mono<Boolean> pathExists(MailboxPath mailboxName) {
        return this.findMailboxByPath(mailboxName).hasElement();
    }

    public Mono<Mailbox> findMailboxById(MailboxId var1);

    public Flux<Mailbox> findNonPersonalMailboxes(Username var1, MailboxACL.Right var2);

    public Flux<Mailbox> findMailboxWithPathLike(MailboxQuery.UserBound var1);

    default public Flux<MailboxId> userMailboxes(Username username) {
        return this.findMailboxWithPathLike(MailboxQuery.builder().privateNamespace().username(username).expression((MailboxNameExpression)Wildcard.INSTANCE).build().asUserBound()).map(Mailbox::getMailboxId);
    }

    public Mono<Boolean> hasChildren(Mailbox var1, char var2);

    public Mono<ACLDiff> updateACL(Mailbox var1, MailboxACL.ACLCommand var2);

    public Mono<ACLDiff> setACL(Mailbox var1, MailboxACL var2);

    public Flux<Mailbox> list();
}

