/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.domainlist.xml;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.core.Domain;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.domainlist.lib.AbstractDomainList;
import org.apache.james.domainlist.lib.DomainListConfiguration;
import org.apache.james.lifecycle.api.Configurable;

@Singleton
public class XMLDomainList
extends AbstractDomainList
implements Configurable {
    private final List<Domain> domainNames = new ArrayList<Domain>();
    private boolean isConfigured = false;

    @Inject
    public XMLDomainList(DNSService dns) {
        super(dns);
    }

    public void configure(DomainListConfiguration domainListConfiguration) throws ConfigurationException {
        super.configure(domainListConfiguration);
        this.isConfigured = true;
    }

    protected List<Domain> getDomainListInternal() {
        return new ArrayList<Domain>(this.domainNames);
    }

    protected boolean containsDomainInternal(Domain domain) throws DomainListException {
        return this.domainNames.contains(domain);
    }

    public void addDomain(Domain domain) throws DomainListException {
        if (this.isConfigured) {
            throw new DomainListException("Read-Only DomainList implementation");
        }
        this.domainNames.add(domain);
    }

    public void doRemoveDomain(Domain domain) throws DomainListException {
        if (this.isConfigured) {
            throw new DomainListException("Read-Only DomainList implementation");
        }
        this.domainNames.remove(domain);
    }
}

