/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.fetch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.james.mailbox.model.Header;

public class MessageResultUtils {
    public static List<Header> getAll(Iterator<Header> iterator) {
        ArrayList<Header> results = new ArrayList<Header>();
        if (iterator != null) {
            while (iterator.hasNext()) {
                results.add(iterator.next());
            }
        }
        return results;
    }

    public static List<Header> getMatching(Collection<String> names, Iterator<Header> iterator) {
        return MessageResultUtils.matching(names, iterator, false);
    }

    private static List<Header> matching(Collection<String> names, Iterator<Header> iterator, boolean not) {
        ArrayList<Header> results = new ArrayList<Header>(names.size());
        if (iterator != null) {
            while (iterator.hasNext()) {
                Header header = iterator.next();
                boolean match = MessageResultUtils.contains(names, header);
                boolean add = not && !match || !not && match;
                if (!add) continue;
                results.add(header);
            }
        }
        return results;
    }

    private static boolean contains(Collection<String> names, Header header) {
        String headerName = header.getName();
        if (headerName != null) {
            for (String name : names) {
                if (!name.equalsIgnoreCase(headerName)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Header> getNotMatching(Collection<String> names, Iterator<Header> iterator) {
        return MessageResultUtils.matching(names, iterator, true);
    }

    public static Header getMatching(String name, Iterator<Header> iterator) {
        Header result = null;
        if (name != null) {
            while (iterator.hasNext()) {
                Header header = iterator.next();
                String headerName = header.getName();
                if (!name.equalsIgnoreCase(headerName)) continue;
                result = header;
                break;
            }
        }
        return result;
    }
}

