/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import jakarta.inject.Inject;
import java.util.Optional;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.mailbox.quota.MaxQuotaManager;
import org.apache.james.webadmin.dto.ValidatedQuotaDTO;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class GlobalQuotaService {
    private final MaxQuotaManager maxQuotaManager;

    @Inject
    public GlobalQuotaService(MaxQuotaManager maxQuotaManager) {
        this.maxQuotaManager = maxQuotaManager;
    }

    public void defineQuota(ValidatedQuotaDTO quota) {
        this.defineGlobalMaxMessage(quota).then(this.defineGlobalMaxStorage(quota)).block();
    }

    private Mono<Void> defineGlobalMaxStorage(ValidatedQuotaDTO quota) {
        return quota.getSize().map(sizeLimit -> Mono.from((Publisher)this.maxQuotaManager.setGlobalMaxStorageReactive(sizeLimit))).orElseGet(() -> Mono.from((Publisher)this.maxQuotaManager.removeGlobalMaxStorageReactive()));
    }

    private Mono<Void> defineGlobalMaxMessage(ValidatedQuotaDTO quota) {
        return quota.getCount().map(countLimit -> Mono.from((Publisher)this.maxQuotaManager.setGlobalMaxMessageReactive(countLimit))).orElseGet(() -> Mono.from((Publisher)this.maxQuotaManager.removeGlobalMaxMessageReactive()));
    }

    public ValidatedQuotaDTO getQuota() {
        return (ValidatedQuotaDTO)Mono.zip((Mono)Mono.from((Publisher)this.maxQuotaManager.getGlobalMaxMessageReactive()).map(Optional::of).switchIfEmpty(Mono.just(Optional.empty())), (Mono)Mono.from((Publisher)this.maxQuotaManager.getGlobalMaxStorageReactive()).map(Optional::of).switchIfEmpty(Mono.just(Optional.empty()))).map(tuple -> ValidatedQuotaDTO.builder().count((Optional)tuple.getT1()).size((Optional)tuple.getT2()).build()).block();
    }

    public Optional<QuotaSizeLimit> getMaxSizeQuota() {
        return Mono.from((Publisher)this.maxQuotaManager.getGlobalMaxStorageReactive()).blockOptional();
    }

    public void defineMaxSizeQuota(QuotaSizeLimit quotaRequest) {
        Mono.from((Publisher)this.maxQuotaManager.setGlobalMaxStorageReactive(quotaRequest)).block();
    }

    public void deleteMaxSizeQuota() {
        Mono.from((Publisher)this.maxQuotaManager.removeGlobalMaxStorageReactive()).block();
    }

    public Optional<QuotaCountLimit> getMaxCountQuota() {
        return Mono.from((Publisher)this.maxQuotaManager.getGlobalMaxMessageReactive()).blockOptional();
    }

    public void defineMaxCountQuota(QuotaCountLimit value) {
        Mono.from((Publisher)this.maxQuotaManager.setGlobalMaxMessageReactive(value)).block();
    }

    public void deleteMaxCountQuota() {
        Mono.from((Publisher)this.maxQuotaManager.removeGlobalMaxMessageReactive()).block();
    }
}

