/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jgroups.Message;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.NoBundler;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.DefaultThreadFactory;

@Experimental
public class AsyncNoBundler
extends NoBundler {
    @Property(description="Max number of threads in thread pool")
    protected int max_threads = 200;
    protected final ThreadPoolExecutor thread_pool = new ThreadPoolExecutor(0, this.max_threads, 30L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DefaultThreadFactory("async-bundler", true, true), new ThreadPoolExecutor.CallerRunsPolicy());

    public AsyncNoBundler() {
        this.thread_pool.allowCoreThreadTimeOut(true);
    }

    @Override
    public void send(Message msg) throws Exception {
        Runnable async_send = () -> {
            ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(msg.size() + 10);
            try {
                this.sendSingleMessage(msg, out);
            }
            catch (Exception e) {
                this.log.error("failed sending message", e);
            }
        };
        this.thread_pool.execute(async_send);
    }
}

