/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import jakarta.inject.Inject;
import java.util.List;
import org.apache.james.core.MailAddress;
import org.apache.james.droplists.api.DropList;
import org.apache.james.droplists.api.DropListEntry;
import org.apache.james.droplists.api.OwnerScope;
import org.apache.james.probe.DropListProbe;
import org.apache.james.utils.GuiceProbe;

public class DropListProbeImpl
implements GuiceProbe,
DropListProbe {
    private final DropList dropList;

    @Inject
    public DropListProbeImpl(DropList dropList) {
        this.dropList = dropList;
    }

    public void addDropListEntry(DropListEntry dropListEntry) {
        this.dropList.add(dropListEntry).block();
    }

    public void removeDropListEntry(DropListEntry dropListEntry) {
        this.dropList.remove(dropListEntry).block();
    }

    public List<DropListEntry> getDropList(OwnerScope ownerScope, String owner) {
        return (List)this.dropList.list(ownerScope, owner).collectList().block();
    }

    public DropList.Status dropListQuery(OwnerScope ownerScope, String owner, MailAddress sender) {
        return (DropList.Status)this.dropList.query(ownerScope, owner, sender).block();
    }
}

