/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.fge.lambdas.Throwing;
import java.time.Instant;
import java.util.Optional;
import org.apache.james.core.MailAddress;
import org.apache.james.json.DTOModule;
import org.apache.james.mailrepository.api.MailRepositoryPath;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.server.task.json.dto.AdditionalInformationDTO;
import org.apache.james.server.task.json.dto.AdditionalInformationDTOModule;
import org.apache.james.util.streams.Limit;
import org.apache.james.webadmin.service.ReprocessingAllMailsTask;
import org.apache.james.webadmin.service.ReprocessingService;

public class ReprocessingAllMailsTaskAdditionalInformationDTO
implements AdditionalInformationDTO {
    private final String type;
    private final String repositoryPath;
    private final String targetQueue;
    private final Optional<String> targetProcessor;
    private final Optional<String> forRecipient;
    private final boolean consume;
    private final long initialCount;
    private final long remainingCount;
    private final Instant timestamp;
    private final Optional<Integer> limit;
    private final Optional<Integer> maxRetries;

    public static AdditionalInformationDTOModule<ReprocessingAllMailsTask.AdditionalInformation, ReprocessingAllMailsTaskAdditionalInformationDTO> module() {
        return (AdditionalInformationDTOModule)DTOModule.forDomainObject(ReprocessingAllMailsTask.AdditionalInformation.class).convertToDTO(ReprocessingAllMailsTaskAdditionalInformationDTO.class).toDomainObjectConverter(dto -> new ReprocessingAllMailsTask.AdditionalInformation(MailRepositoryPath.from((String)dto.repositoryPath), new ReprocessingService.Configuration(MailQueueName.of((String)dto.getTargetQueue()), dto.getTargetProcessor(), dto.getMaxRetries(), dto.forRecipient.map(Throwing.function(MailAddress::new)), dto.isConsume(), Limit.from(dto.getLimit())), dto.initialCount, dto.remainingCount, dto.timestamp)).toDTOConverter((details, type) -> new ReprocessingAllMailsTaskAdditionalInformationDTO(type, details.getRepositoryPath(), details.getConfiguration().getMailQueueName().asString(), details.getConfiguration().getTargetProcessor(), details.getConfiguration().getForRecipient().map(MailAddress::asString), Optional.of(details.getConfiguration().isConsume()), details.getInitialCount(), details.getRemainingCount(), details.timestamp(), details.getConfiguration().getLimit().getLimit(), details.getConfiguration().getMaxRetries())).typeName(ReprocessingAllMailsTask.TYPE.asString()).withFactory(AdditionalInformationDTOModule::new);
    }

    public ReprocessingAllMailsTaskAdditionalInformationDTO(@JsonProperty(value="type") String type, @JsonProperty(value="repositoryPath") String repositoryPath, @JsonProperty(value="targetQueue") String targetQueue, @JsonProperty(value="targetProcessor") Optional<String> targetProcessor, @JsonProperty(value="forRecipient") Optional<String> forRecipient, @JsonProperty(value="consume") Optional<Boolean> consume, @JsonProperty(value="initialCount") long initialCount, @JsonProperty(value="remainingCount") long remainingCount, @JsonProperty(value="timestamp") Instant timestamp, @JsonProperty(value="limit") Optional<Integer> limit, @JsonProperty(value="maxRetries") Optional<Integer> maxRetries) {
        this.type = type;
        this.repositoryPath = repositoryPath;
        this.targetQueue = targetQueue;
        this.targetProcessor = targetProcessor;
        this.forRecipient = forRecipient;
        this.initialCount = initialCount;
        this.remainingCount = remainingCount;
        this.timestamp = timestamp;
        this.consume = consume.orElse(true);
        this.limit = limit;
        this.maxRetries = maxRetries;
    }

    public boolean isConsume() {
        return this.consume;
    }

    public String getType() {
        return this.type;
    }

    public Optional<Integer> getMaxRetries() {
        return this.maxRetries;
    }

    public long getInitialCount() {
        return this.initialCount;
    }

    public long getRemainingCount() {
        return this.remainingCount;
    }

    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    public String getTargetQueue() {
        return this.targetQueue;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public Optional<String> getTargetProcessor() {
        return this.targetProcessor;
    }

    public Optional<String> getForRecipient() {
        return this.forRecipient;
    }

    public Optional<Integer> getLimit() {
        return this.limit;
    }
}

