/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.mailets;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.james.jdkim.DKIMVerifier;
import org.apache.james.jdkim.api.PublicKeyRecordRetriever;
import org.apache.james.jdkim.api.SignatureRecord;
import org.apache.james.jdkim.exceptions.FailException;
import org.apache.james.jdkim.mailets.CRLFInputStream;
import org.apache.james.server.core.MimeMessageInputStream;

public class EncapsulatedDKIMVerifier {
    private final DKIMVerifier originalVerifier;

    public EncapsulatedDKIMVerifier(PublicKeyRecordRetriever publicKeyRecordRetriever) {
        this.originalVerifier = new DKIMVerifier(publicKeyRecordRetriever);
    }

    public List<SignatureRecord> verifyUsingCRLF(MimeMessage message) throws MessagingException, FailException {
        return this.verify(message, true);
    }

    public List<SignatureRecord> verify(MimeMessage message, boolean forceCRLF) throws MessagingException, FailException {
        List list;
        MimeMessageInputStream stream = new MimeMessageInputStream(message);
        try {
            list = forceCRLF ? this.originalVerifier.verify((InputStream)new CRLFInputStream((InputStream)stream)) : this.originalVerifier.verify((InputStream)stream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new MessagingException("Exception calculating bodyhash: " + e.getMessage(), (Exception)e);
            }
        }
        stream.close();
        return list;
    }
}

