/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.repository.file;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.io.FileUtils;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.repository.file.ExtensionFileFilter;
import org.apache.james.repository.file.NumberedRepositoryFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileRepository
implements Configurable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFileRepository.class);
    protected static final boolean DEBUG = false;
    protected static final int BYTE_MASK = 15;
    protected static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected String extension;
    protected String name;
    protected FilenameFilter filter;
    protected File baseDirectory;
    private FileSystem fileSystem;
    private String destination;

    public void configure(HierarchicalConfiguration<ImmutableNode> configuration) throws ConfigurationException {
        this.destination = configuration.getString("[@destinationURL]");
    }

    @Inject
    public void setFileSystem(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    protected abstract String getExtensionDecorator();

    @PostConstruct
    public void init() throws Exception {
        String[] names;
        File directory;
        LOGGER.info("Init {} Store", (Object)this.getClass().getName());
        this.setDestination(this.destination);
        try {
            directory = this.baseDirectory.getCanonicalFile();
        }
        catch (IOException ioe) {
            throw new ConfigurationException("Unable to form canonical representation of " + String.valueOf(this.baseDirectory));
        }
        this.name = "Repository";
        String postfix = this.getExtensionDecorator();
        this.extension = "." + this.name + postfix;
        this.filter = new ExtensionFileFilter(this.extension);
        FileUtils.forceMkdir((File)directory);
        LOGGER.info("{} opened in {}", (Object)this.getClass().getName(), (Object)this.baseDirectory);
        NumberedRepositoryFileFilter numFilter = new NumberedRepositoryFileFilter(this.getExtensionDecorator());
        for (String origFilename : names = directory.list(numFilter)) {
            for (int pos = origFilename.length() - postfix.length(); pos >= 1 && Character.isDigit(origFilename.charAt(pos - 1)); --pos) {
            }
            File origFile = new File(directory, origFilename);
            String newFilename = origFilename.substring(0, pos -= ".".length() + this.name.length()) + this.extension;
            File newFile = new File(directory, newFilename);
            if (origFile.renameTo(newFile)) {
                LOGGER.info("Renamed {} to {}", (Object)origFile, (Object)newFile);
                continue;
            }
            LOGGER.info("Unable to rename {} to {}", (Object)origFile, (Object)newFile);
        }
    }

    protected void setDestination(String destination) throws ConfigurationException {
        if (!destination.startsWith("file://")) {
            throw new ConfigurationException("cannot handle destination " + destination);
        }
        try {
            this.baseDirectory = this.fileSystem.getFileWithinBaseDir(destination);
        }
        catch (IOException e) {
            throw new ConfigurationException("Unable to access destination " + destination, (Throwable)e);
        }
    }

    protected File getFile(String key) throws IOException {
        return new File(this.encode(key));
    }

    protected InputStream getInputStream(String key) throws IOException {
        return new FileInputStream(this.encode(key));
    }

    protected OutputStream getOutputStream(String key) throws IOException {
        return new FileOutputStream(this.getFile(key));
    }

    public synchronized boolean remove(String key) {
        try {
            FileUtils.forceDelete((File)this.getFile(key));
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception caught while removing an object", e);
        }
    }

    public synchronized boolean containsKey(String key) {
        try {
            File file = this.getFile(key);
            return file.exists();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception caught while searching an object", e);
        }
    }

    public Stream<String> list() {
        File storeDir = new File(this.baseDirectory.getAbsolutePath());
        String[] names = storeDir.list(this.filter);
        return Arrays.stream(names).map(this::decode);
    }

    protected String encode(String key) {
        byte[] bytes = key.getBytes();
        char[] buffer = new char[bytes.length << 1];
        int j = 0;
        for (int i = 0; i < bytes.length; ++i) {
            byte k = bytes[i];
            buffer[j++] = HEX_DIGITS[k >>> 4 & 0xF];
            buffer[j++] = HEX_DIGITS[k & 0xF];
        }
        StringBuilder result = new StringBuilder();
        result.append(this.baseDirectory.getAbsolutePath());
        result.append(File.separator);
        result.append(buffer);
        result.append(this.extension);
        return result.toString();
    }

    protected String decode(String filename) {
        filename = filename.substring(0, filename.length() - this.extension.length());
        int size = filename.length();
        byte[] bytes = new byte[size >>> 1];
        int i = 0;
        int j = 0;
        while (i < size) {
            bytes[j] = Byte.parseByte(filename.substring(i, i + 2), 16);
            i += 2;
            ++j;
        }
        return new String(bytes);
    }
}

