/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.droplist.lib;

import jakarta.inject.Inject;
import java.util.List;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.james.core.MailAddress;
import org.apache.james.droplists.api.DropList;
import org.apache.james.droplists.api.DropListEntry;
import org.apache.james.droplists.api.DropListManagementMBean;
import org.apache.james.droplists.api.OwnerScope;

public class DropListManagement
extends StandardMBean
implements DropListManagementMBean {
    private final DropList dropList;

    @Inject
    public DropListManagement(DropList dropList) throws NotCompliantMBeanException {
        super(DropListManagementMBean.class);
        this.dropList = dropList;
    }

    public String query(OwnerScope ownerScope, String owner, MailAddress sender) {
        return (String)this.dropList.query(ownerScope, owner, sender).map(Enum::name).block();
    }

    public List<String> list(OwnerScope ownerScope, String owner) {
        return (List)this.dropList.list(ownerScope, owner).map(DropListEntry::getDeniedEntity).collectList().block();
    }

    public void remove(DropListEntry entry) {
        this.dropList.remove(entry).block();
    }

    public void add(DropListEntry entry) {
        this.dropList.add(entry).block();
    }
}

