/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.blob.deduplication;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import java.time.Clock;
import java.time.Instant;
import java.util.Objects;
import org.apache.james.blob.api.BlobId;
import org.apache.james.server.blob.deduplication.GenerationAware;
import org.apache.james.server.blob.deduplication.GenerationAwareBlobId;

public class MinIOGenerationAwareBlobId
implements BlobId,
GenerationAware {
    private final long generation;
    private final int family;
    private final BlobId delegate;

    @VisibleForTesting
    MinIOGenerationAwareBlobId(long generation, int family, BlobId delegate) {
        Preconditions.checkArgument((generation >= 0L ? 1 : 0) != 0, (Object)"'generation' should not be negative");
        Preconditions.checkArgument((family >= 0 ? 1 : 0) != 0, (Object)"'family' should not be negative");
        this.generation = generation;
        this.family = family;
        this.delegate = delegate;
    }

    public String asString() {
        if (this.family == 0) {
            return this.delegate.asString();
        }
        return this.family + "/" + this.generation + "/" + this.delegate.asString();
    }

    @Override
    public boolean inActiveGeneration(GenerationAwareBlobId.Configuration configuration, Instant now) {
        return configuration.getFamily() == this.family && this.generation + 1L >= GenerationAwareBlobId.computeGeneration(configuration, now);
    }

    @VisibleForTesting
    long getGeneration() {
        return this.generation;
    }

    @VisibleForTesting
    int getFamily() {
        return this.family;
    }

    @VisibleForTesting
    BlobId getDelegate() {
        return this.delegate;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof MinIOGenerationAwareBlobId) {
            MinIOGenerationAwareBlobId other = (MinIOGenerationAwareBlobId)obj;
            return Objects.equals(this.generation, other.generation) && Objects.equals(this.delegate, other.delegate) && Objects.equals(this.family, other.family);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.generation, this.family, this.delegate);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("generation", this.generation).add("delegate", (Object)this.delegate).toString();
    }

    public static class Factory
    implements BlobId.Factory {
        public static final int NO_FAMILY = 0;
        public static final int NO_GENERATION = 0;
        private final Clock clock;
        private final GenerationAwareBlobId.Configuration configuration;
        private final BlobId.Factory delegate;

        @Inject
        public Factory(Clock clock, GenerationAwareBlobId.Configuration configuration, BlobId.Factory delegate) {
            this.clock = clock;
            this.configuration = configuration;
            this.delegate = delegate;
        }

        public BlobId parse(String id) {
            int separatorIndex1 = id.indexOf(47);
            if (separatorIndex1 == -1 || separatorIndex1 == id.length() - 1) {
                return this.decorateWithoutGeneration(id);
            }
            int separatorIndex2 = id.indexOf(47, separatorIndex1 + 1);
            if (separatorIndex2 == -1 || separatorIndex2 == id.length() - 1) {
                return this.decorateWithoutGeneration(id);
            }
            try {
                int family = Integer.parseInt(id.substring(0, separatorIndex1));
                int generation = Integer.parseInt(id.substring(separatorIndex1 + 1, separatorIndex2));
                if (family < 0 || generation < 0) {
                    return this.decorateWithoutGeneration(id);
                }
                BlobId wrapped = this.delegate.parse(id.substring(separatorIndex2 + 1));
                return new MinIOGenerationAwareBlobId(generation, family, wrapped);
            }
            catch (NumberFormatException e) {
                return this.delegate.parse(id.substring(separatorIndex2 + 1));
            }
        }

        private static String injectFoldersInBlobId(String blobIdPart) {
            int folderDepthToCreate = 2;
            if (blobIdPart.length() > folderDepthToCreate) {
                return blobIdPart.charAt(0) + "/" + blobIdPart.charAt(1) + "/" + blobIdPart.substring(2);
            }
            return blobIdPart;
        }

        private GenerationAwareBlobId decorateWithoutGeneration(String id) {
            return new GenerationAwareBlobId(0L, 0, this.delegate.parse(id));
        }

        public BlobId of(String id) {
            return this.decorate(this.delegate.of(Factory.injectFoldersInBlobId(id)));
        }

        private MinIOGenerationAwareBlobId decorate(BlobId blobId) {
            return new MinIOGenerationAwareBlobId(GenerationAwareBlobId.computeGeneration(this.configuration, this.clock.instant()), this.configuration.getFamily(), blobId);
        }
    }
}

